/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.list.ByteList;
import org.basex.util.list.IntList;
import org.basex.util.list.LongList;
import org.basex.util.list.ShortList;

public final class IntSeq
extends NativeSeq {
    private final long[] values;

    private IntSeq(long[] values, Type type) {
        super(values.length, type);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        int size = in.readNum();
        long[] values = new long[size];
        for (int s = 0; s < size; ++s) {
            values[s] = in.readLong();
        }
        return IntSeq.get(values, type);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (long v : this.values) {
            out.writeLong(v);
        }
    }

    @Override
    public Int itemAt(long pos) {
        return Int.get(this.values[(int)pos], this.type);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        long[] tmp = new long[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return IntSeq.get(tmp, this.type);
    }

    public long[] values() {
        return this.values;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Value expr = this;
        if (mode == CompileContext.Simplify.DISTINCT) {
            long[] tmp = new LongList((int)this.size).add(this.values).ddo().finish();
            int tl = tmp.length;
            int t = 0;
            if (this.seqType().type == AtomType.INTEGER) {
                while (++t < tl && tmp[0] + (long)t == tmp[t]) {
                }
            }
            if (t == tl) {
                expr = RangeSeq.get(tmp[0], tl, true);
            } else if ((long)tl != this.size) {
                expr = IntSeq.get(tmp, this.type);
            }
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public Object toJava() {
        switch ((AtomType)this.type) {
            case BYTE: {
                ByteList bl = new ByteList((int)this.size);
                for (long value : this.values) {
                    bl.add((byte)value);
                }
                return bl.finish();
            }
            case SHORT: 
            case UNSIGNED_BYTE: {
                ShortList sl = new ShortList((int)this.size);
                for (long value : this.values) {
                    sl.add((short)value);
                }
                return sl.finish();
            }
            case UNSIGNED_SHORT: {
                char[] chars = new char[(int)this.size];
                int c = 0;
                for (long value : this.values) {
                    chars[c++] = (char)value;
                }
                return chars;
            }
            case INT: {
                IntList il = new IntList((int)this.size);
                for (long value : this.values) {
                    il.add((int)value);
                }
                return il.finish();
            }
        }
        return this.values;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntSeq)) {
            return super.equals(obj);
        }
        IntSeq is = (IntSeq)obj;
        return this.type == is.type && Arrays.equals(this.values, is.values);
    }

    public static Value get(LongList values) {
        return values.isEmpty() ? Empty.VALUE : (values.size() == 1 ? Int.get(values.get(0)) : new IntSeq(values.finish(), (Type)AtomType.INTEGER));
    }

    public static Value get(long[] values) {
        return IntSeq.get(values, AtomType.INTEGER);
    }

    public static Value get(long[] values, Type type) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Int.get(values[0], type) : new IntSeq(values, type));
    }

    static Value get(Type type, int size, Value ... values) throws QueryException {
        LongList tmp = new LongList(size);
        for (Value value : values) {
            if (value instanceof IntSeq) {
                tmp.add(((IntSeq)value).values);
                continue;
            }
            for (Item item : value) {
                tmp.add(item.itr(null));
            }
        }
        return IntSeq.get(tmp.finish(), type);
    }
}

