/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public abstract class AStr
extends Item {
    private static final int[] ASCII = new int[0];
    byte[] value;
    private int[] offsets;

    AStr() {
        super(AtomType.STRING);
    }

    AStr(byte[] value, Type type) {
        super(type);
        this.value = value;
    }

    @Override
    public final boolean bool(InputInfo ii) throws QueryException {
        return this.string(ii).length != 0;
    }

    public boolean ascii(InputInfo ii) throws QueryException {
        if (this.offsets == null) {
            byte[] token = this.string(ii);
            if (Token.ascii(token)) {
                this.offsets = ASCII;
            } else {
                IntList list = new IntList();
                int tl = token.length;
                for (int t = 0; t < tl; t += Token.cl(token, t)) {
                    list.add(t);
                }
                this.offsets = list.finish();
            }
        }
        return this.offsets == ASCII;
    }

    public int length(InputInfo ii) throws QueryException {
        return this.ascii(ii) ? this.string(ii).length : this.offsets.length;
    }

    public AStr substring(InputInfo ii, int start, int end) throws QueryException {
        int s;
        if (start == 0 && end == this.length(ii)) {
            return this;
        }
        byte[] token = this.string(ii);
        boolean ascii = this.ascii(ii);
        int n = s = ascii ? start : this.offsets[start];
        int e = ascii ? end : (end < this.offsets.length ? this.offsets[end] : token.length);
        return Str.get(Arrays.copyOfRange(token, s, e));
    }

    @Override
    public final boolean comparable(Item item) {
        return item.type.isStringOrUntyped();
    }

    @Override
    public final boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        return Token.eq(this.string(ii), item.string(ii), coll);
    }

    @Override
    public final boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        return this.comparable(item) && Token.eq(this.string(deep.info), item.string(deep.info), deep);
    }

    @Override
    public final int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        return Token.diff(this.string(ii), item.string(ii), coll);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AStr)) {
            return false;
        }
        AStr a = (AStr)obj;
        return this.type == a.type && Token.eq(this.value, a.value);
    }

    @Override
    public void toString(QueryString qs) {
        qs.quoted(this.value);
    }
}

