/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.iter.Iter;
import org.basex.query.util.DeepEqualOptions;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;

public final class DeepEqual {
    private static final DeepEqualOptions DEFAULTS = new DeepEqualOptions();
    public final InputInfo info;
    public final QueryContext qc;
    public final Collation coll;
    public final DeepEqualOptions options;
    public boolean nested;

    public DeepEqual() {
        this(null);
    }

    public DeepEqual(InputInfo info) {
        this(info, null, null);
    }

    public DeepEqual(InputInfo info, Collation coll, QueryContext qc) {
        this(info, coll, qc, null);
    }

    public DeepEqual(InputInfo info, Collation coll, QueryContext qc, DeepEqualOptions options) {
        this.info = info;
        this.coll = coll;
        this.qc = qc;
        this.options = options != null ? options : DEFAULTS;
    }

    public boolean equal(Value value1, Value value2) throws QueryException {
        long size2;
        long size1 = value1.size();
        return size1 == (size2 = value2.size()) && (size1 == 1L ? this.equal((Item)value1, (Item)value2) : this.equal(value1.iter(), value2.iter()));
    }

    public boolean equal(Iter iter1, Iter iter2) throws QueryException {
        Item item2;
        Item item1;
        long size1 = iter1.size();
        long size2 = iter2.size();
        if (size1 != -1L && size2 != -1L && size1 != size2) {
            return false;
        }
        do {
            if (this.qc != null) {
                this.qc.checkStop();
            }
            item1 = iter1.next();
            item2 = iter2.next();
            if (item1 != null && item2 != null) continue;
            return item1 == null && item2 == null;
        } while (this.equal(item1, item2));
        return false;
    }

    public boolean equal(Item item1, Item item2) throws QueryException {
        this.nested = false;
        return item1 == item2 || item1.deepEqual(item2, this);
    }
}

