/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.job;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.jobs.JobOptions;
import org.basex.core.jobs.Jobs;
import org.basex.core.jobs.QueryJob;
import org.basex.core.jobs.QueryJobSpec;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;

public class JobEval
extends StandardFunc {
    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.eval(this.toContent(this.arg(0), qc), qc);
    }

    private Str eval(IOContent query, QueryContext qc) throws QueryException {
        HashMap<String, Value> bindings = this.toBindings(this.arg(1), qc);
        JobOptions options = this.toOptions(this.arg(2), new JobOptions(), true, qc);
        options.set(JobOptions.BASE_URI, this.toBaseUri(query.url(), options, JobOptions.BASE_URI));
        boolean service = Boolean.TRUE.equals(options.get(JobOptions.SERVICE));
        if (service) {
            if (!bindings.isEmpty()) {
                throw QueryError.JOBS_SERVICE.get(this.info, new Object[0]);
            }
            options.put(JobOptions.SERVICE, null);
        }
        for (Map.Entry<String, Value> it : bindings.entrySet()) {
            bindings.put(it.getKey(), it.getValue().materialize(n -> false, this.info, qc));
        }
        QueryJobSpec spec = new QueryJobSpec(options, bindings, query);
        QueryJob job = new QueryJob(spec, qc.context, this.info, null, qc);
        if (service) {
            if (!bindings.isEmpty()) {
                throw QueryError.JOBS_SERVICE.get(this.info, new Object[0]);
            }
            try {
                Jobs jobs = new Jobs(qc.context);
                jobs.add(spec);
                jobs.write();
            }
            catch (IOException ex) {
                throw QueryError.JOBS_SERVICE_X_X.get(this.info, ex);
            }
        }
        return Str.get(job.jc().id());
    }
}

