/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.IdentityHashMap;
import org.basex.data.Data;
import org.basex.index.IndexNames;
import org.basex.index.IndexType;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.expr.index.IndexStaticDb;
import org.basex.query.expr.index.ValueAccess;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ANodeBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenSet;

abstract class Ids
extends ContextFn {
    private final IdentityHashMap<Data, Boolean> indexed = new IdentityHashMap();

    Ids() {
    }

    protected final Value ids(QueryContext qc, boolean idref) throws QueryException {
        TokenSet idSet = this.ids(this.arg(0).atomIter(qc, this.info), qc);
        ANode root = this.toRoot(this.toNode(this.context(qc), qc));
        ANodeBuilder list = new ANodeBuilder();
        if (this.index(root, idref)) {
            Item item;
            Data data = root.data();
            ValueAccess va = new ValueAccess(this.info, idSet, idref ? IndexType.TOKEN : IndexType.ATTRIBUTE, null, (IndexDb)new IndexStaticDb(data, this.info));
            Iter iter = va.iter(qc);
            while ((item = iter.next()) != null) {
                ANode attr = (ANode)item;
                if (!XMLToken.isId(attr.name(), idref) || data.meta.ndocs != 1 && !attr.root().is(root)) continue;
                list.add(idref ? attr : attr.parent());
            }
        } else {
            Ids.add(idSet, list, root, idref);
        }
        return list.value(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean index(ANode root, boolean idref) {
        Data data = root.data();
        if (data == null || (idref ? !data.meta.tokenindex : !data.meta.attrindex)) {
            return false;
        }
        IdentityHashMap<Data, Boolean> identityHashMap = this.indexed;
        synchronized (identityHashMap) {
            return this.indexed.computeIfAbsent(data, d -> new IndexNames(IndexType.ATTRIBUTE, (Data)d).containsIds(idref));
        }
    }

    private static void add(TokenSet idSet, ANodeBuilder results, ANode node, boolean idref) {
        block0: for (ANode attr : node.attributeIter()) {
            if (!XMLToken.isId(attr.name(), idref)) continue;
            for (byte[] token : Token.distinctTokens(attr.string())) {
                if (!idSet.contains(token)) continue;
                results.add(idref ? attr.finish() : node.finish());
                continue block0;
            }
        }
        for (ANode child : node.childIter()) {
            Ids.add(idSet, results, child, idref);
        }
    }

    private ANode toRoot(ANode node) throws QueryException {
        ANode root = node.root();
        if (root.type != NodeType.DOCUMENT_NODE) {
            throw QueryError.IDDOC.get(this.info, new Object[0]);
        }
        return root;
    }

    private TokenSet ids(Iter iter, QueryContext qc) throws QueryException {
        Item ids;
        TokenSet ts = new TokenSet();
        while ((ids = qc.next(iter)) != null) {
            for (byte[] id : Token.distinctTokens(this.toToken(ids))) {
                ts.put(id);
            }
        }
        return ts;
    }

    @Override
    public final int contextIndex() {
        return 1;
    }

    @Override
    public final boolean ddo() {
        return true;
    }
}

