/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import org.basex.io.in.NewlineInput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.FnUnparsedTextAvailable;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class FnUnparsedTextLines
extends FnUnparsedTextAvailable {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        Item text = this.unparsedText(qc, false, true);
        return text.isEmpty() ? Empty.ITER : new LinesIter(text.string(this.info));
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value;
        Item text = this.unparsedText(qc, false, true);
        if (text.isEmpty()) {
            return Empty.VALUE;
        }
        NewlineInput ni = new NewlineInput(text.string(this.info));
        try {
            TokenList tl = new TokenList();
            TokenBuilder tb = new TokenBuilder();
            while (ni.readLine(tb)) {
                qc.checkStop();
                tl.add(tb.toArray());
            }
            value = StrSeq.get(tl);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ni.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw QueryError.FILE_IO_ERROR_X.get(this.info, ex);
            }
        }
        ni.close();
        return value;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr href = this.arg(0);
        return href.seqType().zero() ? href : super.opt(cc);
    }

    private static final class LinesIter
    extends Iter {
        private final TokenBuilder tb = new TokenBuilder();
        private final NewlineInput nli;

        private LinesIter(byte[] contents) {
            try {
                this.nli = new NewlineInput(contents);
            }
            catch (IOException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }

        @Override
        public Str next() {
            try {
                return this.nli.readLine(this.tb) ? Str.get(this.tb.toArray()) : null;
            }
            catch (IOException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }
    }
}

