/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.fn.FnJsonDoc;
import org.basex.query.func.fn.UriOptions;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public class FnParseUri
extends FnJsonDoc {
    static final String URI = "uri";
    static final String SCHEME = "scheme";
    static final String HIERARCHICAL = "hierarchical";
    static final String AUTHORITY = "authority";
    static final String USERINFO = "userinfo";
    static final String HOST = "host";
    static final String PORT = "port";
    static final String PATH = "path";
    static final String QUERY = "query";
    static final String FRAGMENT = "fragment";
    static final String PATH_SEGMENTS = "path-segments";
    static final String QUERY_SEGMENTS = "query-segments";
    static final String FILEPATH = "filepath";
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String FILE = "file";
    static HashMap<String, String> ports = new HashMap();

    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        String value = this.toString(this.arg(0), qc);
        UriOptions options = this.toOptions(this.arg(1), new UriOptions(), false, qc);
        Object string = value.replace('\\', '/');
        String fragment = "";
        String query = "";
        String scheme = "";
        Object filepath = "";
        String authority = "";
        String userinfo = "";
        String host = "";
        String port = "";
        Object path = "";
        Item hierarchical = Empty.VALUE;
        Matcher m = Pattern.compile("^(.*)#([^#]*)$").matcher((CharSequence)string);
        if (m.matches()) {
            fragment = m.group(2);
            string = m.group(1);
        }
        if ((m = Pattern.compile("^(.*)\\?([^?]*)$").matcher((CharSequence)string)).matches()) {
            query = m.group(2);
            string = m.group(1);
        }
        if (((String)string).matches("^[a-zA-Z][:|].*$")) {
            scheme = FILE;
            filepath = string = ((String)string).replaceAll("^(.)\\|", "$1:");
            string = "/" + (String)string;
        } else {
            m = Pattern.compile("^([a-zA-Z][-+.A-Za-z0-9]*):(.*)$").matcher((CharSequence)string);
            if (m.matches()) {
                scheme = m.group(1);
                string = m.group(2);
            }
        }
        if (options.get(UriOptions.UNC_PATH).booleanValue() && scheme.isEmpty() && ((String)string).matches("^//[^/].*$")) {
            scheme = FILE;
            filepath = string;
        }
        if (!((String)string).isEmpty()) {
            hierarchical = Bln.get(((String)string).startsWith("/"));
        }
        if ((m = Pattern.compile("^//*([a-zA-Z]:.*)$").matcher((CharSequence)string)).matches()) {
            string = m.group(1);
        } else {
            m = Pattern.compile("^///*([^/]+)(/.*)?$").matcher((CharSequence)string);
            if (m.matches()) {
                authority = m.group(1);
                string = m.group(2);
            }
        }
        if (string == null) {
            string = "";
        }
        if ((m = Pattern.compile("^(([^@]*)@)(.*)(:([^:]*))?$").matcher(authority)).matches()) {
            userinfo = m.group(2);
            if (!options.get(UriOptions.ALLOW_DEPRECATED_FEATURES).booleanValue() && userinfo.contains(":")) {
                userinfo = "";
            }
        }
        if ((m = Pattern.compile("^(([^@]*)@)?(\\[[^\\]]*\\])(:([^:]*))?$").matcher(authority)).matches()) {
            host = m.group(3);
        } else {
            if (authority.matches("^(([^@]*)@)?\\[.*$")) {
                throw QueryError.PARSE_URI_X.get(this.info, value);
            }
            m = Pattern.compile("^(([^@]*)@)?([^:]+)(:([^:]*))?$").matcher(authority);
            if (m.matches()) {
                host = m.group(3);
            }
        }
        if (host == null) {
            host = "";
        }
        if ((m = Pattern.compile("^(([^@]*)@)?(\\[[^\\]]*\\])(:([^:]*))?$").matcher(authority)).matches()) {
            port = m.group(5);
        } else {
            m = Pattern.compile("^(([^@]*)@)?([^:]+)(:([^:]*))?$").matcher(authority);
            if (m.matches()) {
                port = m.group(5);
            }
        }
        if (port == null) {
            port = "";
        }
        if (FnParseUri.omitPort(port, scheme, options)) {
            port = "";
        }
        path = string;
        if (((String)filepath).isEmpty() && (scheme.isEmpty() || scheme.equals(FILE))) {
            filepath = string;
        }
        ArrayBuilder segments = new ArrayBuilder();
        if (!((String)string).isEmpty()) {
            String separator = Pattern.quote(options.get(UriOptions.PATH_SEPARATOR));
            for (String s : ((String)string).split(separator)) {
                segments.append(Str.get(FnParseUri.decode(s)));
            }
        }
        ArrayBuilder queries = new ArrayBuilder();
        if (!query.isEmpty()) {
            String separator = Pattern.quote(options.get(UriOptions.QUERY_SEPARATOR));
            for (String q : query.split(separator)) {
                int eq = q.indexOf(61);
                String k = eq == -1 ? "" : q.substring(0, eq);
                String v = q.substring(eq + 1);
                queries.append(new MapBuilder(this.info).put(KEY, k).put(VALUE, v).map());
            }
        }
        filepath = FnParseUri.decode((String)filepath);
        MapBuilder map = new MapBuilder(this.info);
        FnParseUri.add(map, URI, value);
        FnParseUri.add(map, SCHEME, scheme);
        FnParseUri.add(map, HIERARCHICAL, hierarchical);
        FnParseUri.add(map, AUTHORITY, authority);
        FnParseUri.add(map, USERINFO, userinfo);
        FnParseUri.add(map, HOST, host);
        FnParseUri.add(map, PORT, port);
        FnParseUri.add(map, PATH, path);
        FnParseUri.add(map, QUERY, query);
        FnParseUri.add(map, FRAGMENT, fragment);
        FnParseUri.add(map, PATH_SEGMENTS, segments.array());
        FnParseUri.add(map, QUERY_SEGMENTS, queries.array());
        FnParseUri.add(map, FILEPATH, filepath);
        return map.map();
    }

    static void add(MapBuilder map, String k, Object v) throws QueryException {
        Value value;
        Value value2 = v instanceof Value ? (Value)v : (value = v.toString().isEmpty() ? Empty.VALUE : Str.get(v.toString()));
        if (!(value.isEmpty() || value instanceof XQMap && ((XQMap)value).mapSize() == 0 || value instanceof XQArray && ((XQArray)value).arraySize() == 0L)) {
            map.put(k, value);
        }
    }

    static String decode(String string) {
        int sl = string.length();
        TokenBuilder tb = new TokenBuilder(sl);
        for (int s = 0; s < sl; ++s) {
            int b = string.codePointAt(s);
            if (b == 43) {
                b = 32;
            } else if (b == 37) {
                int b2;
                b = 65533;
                int b1 = s + 1 < sl ? Token.dec(string.charAt(s + 1)) : -1;
                int n = b2 = s + 2 < sl ? Token.dec(string.charAt(s + 2)) : -1;
                if (b1 != -1 && b2 != -1) {
                    b = b1 << 4 | b2;
                    s += 2;
                } else if (b2 == -1) {
                    ++s;
                }
            }
            if (b == 65533) {
                tb.add(65533);
                continue;
            }
            tb.addByte((byte)b);
        }
        return tb.toString();
    }

    static boolean omitPort(String port, String scheme, UriOptions options) {
        return options.get(UriOptions.OMIT_DEFAULT_PORTS) != false && Objects.equals(ports.get(scheme), port);
    }

    static {
        ports.put("http", "80");
        ports.put("https", "443");
        ports.put("ftp", "21");
        ports.put("ssh", "22");
    }
}

