/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryRTException;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.Parse;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public class FnJsonDoc
extends Parse {
    private static final FuncType STRFUNC = FuncType.get(SeqType.STRING_O, SeqType.STRING_O);

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        try {
            item = this.unparsedText(qc, false, false);
        }
        catch (QueryException ex) {
            Util.debug(ex);
            throw ex.error() == QueryError.INVCHARS_X ? QueryError.PARSE_JSON_X.get(this.info, ex.getLocalizedMessage()) : ex;
        }
        return item.isEmpty() ? Empty.VALUE : this.parse(item.string(this.info), false, qc);
    }

    @Override
    protected final Expr opt(CompileContext cc) {
        return this.optFirst();
    }

    final Item parse(byte[] json, boolean xml, QueryContext qc) throws QueryException {
        FItem fallback;
        JsonParserOptions options = this.toOptions(this.arg(1), new JsonParserOptions(), false, qc);
        boolean esc = options.get(JsonParserOptions.ESCAPE);
        FuncItem fb = options.get(JsonParserOptions.FALLBACK);
        FItem fItem = fallback = fb == null ? null : STRFUNC.cast(fb, qc, this.sc, this.info);
        if (esc && fallback != null) {
            throw QueryError.OPTION_JSON_X.get(this.info, "Escaping cannot be combined with a fallback function.");
        }
        try {
            options.set(JsonOptions.FORMAT, xml ? JsonOptions.JsonFormat.BASIC : JsonOptions.JsonFormat.XQUERY);
            JsonConverter conv = JsonConverter.get(options);
            if (!esc && fallback != null) {
                conv.fallback(string -> {
                    try {
                        Item item = fallback.invoke(qc, this.info, Str.get(string)).item(qc, this.info);
                        return Token.string(item.string(this.info));
                    }
                    catch (QueryException ex) {
                        throw new QueryRTException(ex);
                    }
                });
            }
            return conv.convert(Token.string(json), "");
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        catch (QueryIOException ex) {
            Util.debug(ex);
            QueryException qe = ex.getCause(this.info);
            QueryError error = qe.error();
            String message = ex.getLocalizedMessage();
            if (error == QueryError.JSON_PARSE_X_X_X) {
                throw QueryError.PARSE_JSON_X.get(this.info, message);
            }
            if (error == QueryError.JSON_DUPL_X_X_X) {
                throw QueryError.DUPLICATE_JSON_X.get(this.info, message);
            }
            if (error == QueryError.JSON_OPTIONS_X) {
                throw QueryError.OPTION_JSON_X.get(this.info, message);
            }
            throw qe;
        }
    }
}

