/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class FnBaseUri
extends ContextFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        ANode node = this.toNodeOrNull(this.context(qc), qc);
        Uri uri = FnBaseUri.uri(node, this.sc.baseURI(), this.info);
        return uri == null ? Empty.VALUE : uri;
    }

    @Override
    protected Expr opt(CompileContext cc) {
        return this.optFirst(false, false, cc.qc.focus.value);
    }

    public static Uri uri(ANode node, Uri staticBase, InputInfo info) throws QueryException {
        if (node == null) {
            return null;
        }
        Type type = node.type;
        if (!type.oneOf(NodeType.ELEMENT, NodeType.DOCUMENT_NODE) && node.parent() == null) {
            return null;
        }
        Uri base = Uri.EMPTY;
        ANode nd = node;
        do {
            if (nd == null) {
                return staticBase != null ? staticBase.resolve(base, info) : Uri.EMPTY;
            }
            Uri bu = Uri.get(nd.baseURI(), false);
            if (!bu.isValid()) {
                throw QueryError.INVURI_X.get(info, new Object[]{nd.baseURI()});
            }
            base = bu.resolve(base, info);
            if (nd.type == NodeType.DOCUMENT_NODE && nd instanceof DBNode) break;
            nd = nd.parent();
        } while (!base.isAbsolute());
        return base;
    }
}

