/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.query.expr.path.DocTest;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Test;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Util;

public class KindTest
extends Test {
    public static final KindTest DOCUMENT_NODE = new KindTest(NodeType.DOCUMENT_NODE);
    public static final KindTest ELEMENT = new KindTest(NodeType.ELEMENT){

        @Override
        public String toString(boolean full) {
            return full ? this.type.toString() : "*";
        }
    };
    public static final KindTest ATTRIBUTE = new KindTest(NodeType.ATTRIBUTE);
    public static final KindTest PROCESSING_INSTRUCTION = new KindTest(NodeType.PROCESSING_INSTRUCTION);
    public static final KindTest TEXT = new KindTest(NodeType.TEXT);
    public static final KindTest COMMENT = new KindTest(NodeType.COMMENT);
    public static final KindTest NAMESPACE_NODE = new KindTest(NodeType.NAMESPACE_NODE);
    public static final KindTest NODE = new KindTest(NodeType.NODE){

        @Override
        public boolean matches(ANode node) {
            return true;
        }

        @Override
        public boolean instanceOf(Test test) {
            return false;
        }

        @Override
        public Test intersect(Test test) {
            return test;
        }
    };

    KindTest(NodeType type) {
        super(type);
    }

    public static KindTest get(NodeType type) {
        switch (type) {
            case TEXT: {
                return TEXT;
            }
            case PROCESSING_INSTRUCTION: {
                return PROCESSING_INSTRUCTION;
            }
            case ELEMENT: {
                return ELEMENT;
            }
            case DOCUMENT_NODE: {
                return DOCUMENT_NODE;
            }
            case ATTRIBUTE: {
                return ATTRIBUTE;
            }
            case COMMENT: {
                return COMMENT;
            }
            case NODE: {
                return NODE;
            }
            case NAMESPACE_NODE: {
                return NAMESPACE_NODE;
            }
        }
        throw Util.notExpected();
    }

    @Override
    public final KindTest copy() {
        return this;
    }

    @Override
    public boolean matches(ANode node) {
        return node.type == this.type;
    }

    @Override
    public Boolean matches(SeqType seqType) {
        Type tp = seqType.type;
        if (tp.intersect(this.type) == null) {
            return Boolean.FALSE;
        }
        return tp.instanceOf(this.type) ? Boolean.TRUE : null;
    }

    @Override
    public boolean instanceOf(Test test) {
        return (test instanceof KindTest || test instanceof UnionTest) && super.instanceOf(test);
    }

    @Override
    public Test intersect(Test test) {
        if (test instanceof KindTest) {
            return this.instanceOf(test) ? this : (test.instanceOf(this) ? test : null);
        }
        if (test instanceof NameTest || test instanceof DocTest) {
            return test.instanceOf(this) ? test : null;
        }
        if (test instanceof UnionTest) {
            return test.intersect(this);
        }
        return null;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public String toString(boolean full) {
        return this.type.toString();
    }
}

