/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.Single;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.Eval;
import org.basex.query.expr.gflwor.Group;
import org.basex.query.expr.gflwor.GroupSpec;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.Flag;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.BitArray;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class GroupBy
extends Clause {
    private final GroupSpec[] specs;
    private Expr[] preExpr;
    private Var[] post;
    private final int nonOcc;

    public GroupBy(GroupSpec[] specs, VarRef[] pre, Var[] post, InputInfo info) {
        super(info, SeqType.ITEM_ZM, GroupBy.vars(specs, post));
        this.specs = specs;
        this.post = post;
        this.preExpr = Array.copy(pre, new Expr[pre.length]);
        int n = 0;
        for (GroupSpec spec : specs) {
            if (spec.occluded) continue;
            ++n;
        }
        this.nonOcc = n;
    }

    private GroupBy(GroupSpec[] specs, Expr[] pre, Var[] post, int nonOcc, InputInfo info) {
        super(info, SeqType.ITEM_ZM, GroupBy.vars(specs, post));
        this.specs = specs;
        this.preExpr = pre;
        this.post = post;
        this.nonOcc = nonOcc;
    }

    private static Var[] vars(GroupSpec[] gs, Var[] vs) {
        int gl = gs.length;
        int vl = vs.length;
        Var[] vars = new Var[gl + vl];
        for (int g = 0; g < gl; ++g) {
            vars[g] = gs[g].var;
        }
        Array.copyFromStart(vs, vl, vars, gl);
        return vars;
    }

    @Override
    Eval eval(final Eval sub) {
        return new Eval(){
            private Group[] groups;
            private int pos;

            @Override
            public boolean next(QueryContext qc) throws QueryException {
                if (this.groups == null) {
                    this.groups = this.init(qc);
                }
                if (this.pos == this.groups.length) {
                    return false;
                }
                Group curr = this.groups[this.pos];
                this.groups[this.pos++] = null;
                int p = 0;
                for (GroupSpec spec : GroupBy.this.specs) {
                    if (spec.occluded) continue;
                    Item key = curr.key[p++];
                    qc.set(spec.var, key == null ? Empty.VALUE : key);
                }
                int pl = GroupBy.this.post.length;
                for (int i = 0; i < pl; ++i) {
                    qc.set(GroupBy.this.post[i], curr.ngv[i].value(GroupBy.this.preExpr[i]));
                }
                return true;
            }

            private Group[] init(QueryContext qc) throws QueryException {
                ArrayList<Group> grps = new ArrayList<Group>();
                IntObjMap<Group> map = new IntObjMap<Group>();
                DeepEqual[] deeps = new DeepEqual[GroupBy.this.nonOcc];
                int c = 0;
                for (GroupSpec groupSpec : GroupBy.this.specs) {
                    if (groupSpec.occluded) continue;
                    deeps[c++] = new DeepEqual(GroupBy.this.info, groupSpec.coll, qc);
                }
                while (sub.next(qc)) {
                    Group group;
                    Item[] key = new Item[GroupBy.this.nonOcc];
                    int p = 0;
                    int hash = 1;
                    for (GroupSpec spec : GroupBy.this.specs) {
                        Item atom = spec.atomItem(qc, GroupBy.this.info);
                        if (!spec.occluded) {
                            key[p++] = atom;
                            hash = 31 * hash + (atom.isEmpty() || spec.coll != null ? 0 : atom.hash(GroupBy.this.info));
                        }
                        qc.set(spec.var, atom);
                    }
                    Group grp = null;
                    Group g = group = (Group)map.get(hash);
                    while (g != null) {
                        if (this.eq(key, g.key, deeps)) {
                            grp = g;
                            break;
                        }
                        g = g.next;
                    }
                    int pl = GroupBy.this.preExpr.length;
                    if (grp == null) {
                        ValueBuilder[] ngs = new ValueBuilder[pl];
                        int nl = ngs.length;
                        for (int n = 0; n < nl; ++n) {
                            ngs[n] = new ValueBuilder(qc);
                        }
                        grp = new Group(key, ngs);
                        grps.add(grp);
                        if (group == null) {
                            map.put(hash, grp);
                        } else {
                            Group nxt = group.next;
                            group.next = grp;
                            grp.next = nxt;
                        }
                    }
                    for (int g2 = 0; g2 < pl; ++g2) {
                        grp.ngv[g2].add(GroupBy.this.preExpr[g2].value(qc));
                    }
                }
                return (Group[])grps.toArray(Group[]::new);
            }

            private boolean eq(Item[] items1, Item[] items2, DeepEqual[] deeps) throws QueryException {
                int il = items1.length;
                for (int i = 0; i < il; ++i) {
                    boolean empty2;
                    Item item1 = items1[i];
                    Item item2 = items2[i];
                    boolean empty1 = item1.isEmpty();
                    if (!(empty1 ^ (empty2 = item2.isEmpty())) && (empty1 || deeps[i].equal(item1, item2))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Expr expr : this.preExpr) {
            if (!expr.has(flags)) continue;
            return true;
        }
        for (Expr expr : this.specs) {
            if (!((Single)expr).has(flags)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GroupBy compile(CompileContext cc) throws QueryException {
        for (Expr expr : this.preExpr) {
            expr.compile(cc);
        }
        for (Expr expr : this.specs) {
            ((GroupSpec)expr).compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public GroupBy optimize(CompileContext cc) throws QueryException {
        int pl = this.preExpr.length;
        for (int p = 0; p < pl; ++p) {
            this.post[p].refineType(this.preExpr[p].seqType().union(Occ.ONE_OR_MORE), cc);
        }
        this.exprType.assign(SeqType.union(this.specs, true));
        return this;
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (GroupSpec spec : this.specs) {
            if (spec.inlineable(ic)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.specs).plus(VarUsage.sum(var, this.preExpr));
    }

    @Override
    public Clause inline(InlineContext ic) throws QueryException {
        boolean a = ic.inline(this.specs);
        boolean b = ic.inline(this.preExpr);
        return a || b ? this.optimize(ic.cc) : null;
    }

    @Override
    public GroupBy copy(CompileContext cc, IntObjMap<Var> vm) {
        Expr[] pEx = Arr.copyAll((CompileContext)cc, vm, (Expr[])this.preExpr);
        Var[] ps = new Var[this.post.length];
        int pl = ps.length;
        for (int p = 0; p < pl; ++p) {
            ps[p] = cc.copy(this.post[p], vm);
        }
        return this.copyType(new GroupBy((GroupSpec[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.specs), pEx, ps, this.nonOcc, this.info));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (!GroupBy.visitAll(visitor, this.specs)) {
            return false;
        }
        for (Expr expr : this.preExpr) {
            if (expr.accept(visitor)) continue;
            return false;
        }
        for (ExprInfo exprInfo : this.post) {
            if (visitor.declared((Var)exprInfo)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean clean(IntObjMap<Var> decl, BitArray used) {
        int len = this.preExpr.length;
        for (int p = 0; p < this.post.length; ++p) {
            if (used.get(this.post[p].id)) continue;
            this.preExpr = Array.remove(this.preExpr, p);
            this.post = Array.remove(this.post, p--);
        }
        return this.preExpr.length < len;
    }

    @Override
    boolean skippable(Clause cl) {
        return false;
    }

    GroupSpec group() {
        if (this.specs.length == 1 && this.post.length == 0) {
            GroupSpec spec = this.specs[0];
            SeqType st = spec.expr.seqType();
            if (spec.coll == null && spec.var.declType == null && st.one() && !st.mayBeArray()) {
                return spec;
            }
        }
        return null;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.preExpr);
        this.checkNoneUp(this.specs);
    }

    @Override
    public void calcSize(long[] minMax) {
        minMax[0] = Math.min(minMax[0], 1L);
    }

    @Override
    public int exprSize() {
        int size = 0;
        for (Expr expr : this.preExpr) {
            size += expr.exprSize();
        }
        for (Expr expr : this.specs) {
            size += expr.exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroupBy)) {
            return false;
        }
        GroupBy g = (GroupBy)obj;
        return Array.equals(this.specs, g.specs) && Array.equals(this.preExpr, g.preExpr) && Array.equals(this.post, g.post);
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.specs);
    }

    @Override
    public void toString(QueryString qs) {
        int pl = this.post.length;
        for (int p = 0; p < pl; ++p) {
            qs.token("let").token("(: post-group :)").token(this.post[p]).token(":=").token(this.preExpr[p]);
        }
        qs.token("group").token("by").tokens(this.specs, ", ");
    }
}

