/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Union;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.LongList;

public final class List
extends Arr {
    public List(InputInfo info, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
    }

    public static Expr get(CompileContext cc, InputInfo ii, Expr ... exprs) throws QueryException {
        int el = exprs.length;
        return el > 1 ? new List(ii, exprs).optimize(cc) : (el > 0 ? exprs[0] : Empty.VALUE);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkAllUp(this.exprs);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.flatten(cc);
        this.removeEmpty(cc);
        this.toRange(cc);
        this.toReplicate(cc);
        int el = this.exprs.length;
        if (el == 0) {
            return cc.emptySeq(this);
        }
        if (el == 1) {
            return this.exprs[0];
        }
        SeqType st = SeqType.union(this.exprs, false);
        Occ occ = Occ.ZERO;
        long size = 0L;
        for (Expr expr : this.exprs) {
            long sz = expr.size();
            if (size != -1L) {
                size = sz == -1L ? -1L : size + sz;
            }
            occ = occ.add(expr.seqType().occ);
        }
        this.exprType.assign(st != null ? st : SeqType.EMPTY_SEQUENCE_Z, occ, size).data(this.exprs);
        if (this.allAreValues(true)) {
            void var10_14;
            Type type = null;
            Value[] values = new Value[el];
            int vl = 0;
            for (Expr expr : this.exprs) {
                cc.qc.checkStop();
                Value value = expr.value(cc.qc);
                Type tp = value.type;
                if (vl == 0) {
                    type = tp;
                } else if (type != null && !type.eq(tp)) {
                    type = null;
                }
                values[vl++] = value;
            }
            Value value = Seq.get((int)size, type, values);
            if (value == null) {
                ValueBuilder vb = new ValueBuilder(cc.qc);
                for (int v = 0; v < vl; ++v) {
                    vb.add(values[v]);
                }
                Value value2 = vb.value(this);
            }
            return cc.replaceWith(this, (Expr)var10_14);
        }
        return this;
    }

    private void toReplicate(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        ExprList list = new ExprList(el);
        int s = 0;
        int e = 0;
        while (++e <= el) {
            if (e != el && this.exprs[e].equals(this.exprs[s])) continue;
            if (e - s > 1) {
                list.add(cc.replicate(this.exprs[s], Int.get(e - s), this.info));
                cc.info("merge: %", list.peek());
            } else {
                while (s < e) {
                    list.add(this.exprs[s++]);
                }
            }
            s = e;
        }
        this.exprs = (Expr[])list.finish();
    }

    private void toRange(CompileContext cc) {
        if (!((Checks<Expr>)expr -> expr instanceof Int || expr instanceof RangeSeq).any((Expr[])this.exprs)) {
            return;
        }
        long[] range = null;
        int el = this.exprs.length;
        ExprList list = new ExprList(el);
        for (int e = 0; e <= el; ++e) {
            boolean add;
            Expr expr2 = e < el ? this.exprs[e] : null;
            long[] rng = null;
            if (expr2 instanceof Int && expr2.seqType().type == AtomType.INTEGER) {
                long l = ((Int)expr2).itr();
                rng = new long[]{l, l};
            } else if (expr2 instanceof RangeSeq && (rng = ((RangeSeq)expr2).range(true))[1] < rng[0]) {
                rng = null;
            }
            boolean bl = add = rng == null;
            if (!add) {
                if (range == null) {
                    range = rng;
                } else if (rng[0] == range[1] + 1L) {
                    range[1] = rng[1];
                } else {
                    add = true;
                }
            }
            if (!add) continue;
            if (range != null) {
                long s = range[1] - range[0] + 1L;
                list.add(RangeSeq.get(range[0], s, true));
                if (s > 1L) {
                    cc.info("merge: %", list.peek());
                }
                range = rng;
            }
            if (range != null || expr2 == null) continue;
            list.add(expr2);
        }
        this.exprs = (Expr[])list.finish();
    }

    @Override
    public Iter iter(final QueryContext qc) {
        return new Iter(){
            private final int el;
            private final Iter[] iters;
            private long[] offsets;
            private long size;
            private int e;
            {
                this.el = List.this.exprs.length;
                this.iters = new Iter[this.el];
            }

            @Override
            public Item next() throws QueryException {
                while (this.e < this.el) {
                    Item item = qc.next(this.iter(this.e));
                    if (item != null) {
                        return item;
                    }
                    ++this.e;
                }
                return null;
            }

            @Override
            public Item get(long i) throws QueryException {
                int o;
                for (o = 0; o < this.el - 1 && this.offsets[o + 1] <= i; ++o) {
                }
                return this.iter(o).get(i - this.offsets[o]);
            }

            @Override
            public long size() throws QueryException {
                if (this.offsets == null) {
                    this.offsets = new long[this.el];
                    for (int o = 0; o < this.el && this.size != -1L; ++o) {
                        this.offsets[o] = this.size;
                        long s = this.iter(o).size();
                        this.size = s == -1L || this.size + s < 0L ? -1L : this.size + s;
                    }
                }
                return this.size;
            }

            private Iter iter(int i) throws QueryException {
                Iter iter = this.iters[i];
                if (iter == null) {
                    this.iters[i] = iter = List.this.exprs[i].iter(qc);
                }
                return iter;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        if (this.exprs.length == 2) {
            return ValueBuilder.concat(this.exprs[0].value(qc), this.exprs[1].value(qc), qc);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (Expr expr : this.exprs) {
            vb.add(expr.value(qc));
        }
        return vb.value(this);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        if (mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE)) {
            expr = this.toUnion(cc);
        } else if (mode == CompileContext.Simplify.DISTINCT) {
            int el = this.exprs.length;
            ExprList list = new ExprList(el);
            for (Expr ex : this.exprs) {
                list.addUnique(ex.simplifyFor(mode, cc));
            }
            this.exprs = (Expr[])list.finish();
            expr = this.exprs.length != el ? List.get(cc, this.info, this.exprs) : (this.seqType().type == AtomType.INTEGER ? this.toDistinctRange() : this.toUnion(cc));
        } else {
            Expr[] ex = this.simplifyAll(mode, cc);
            if (ex != this.exprs) {
                expr = List.get(cc, this.info, ex);
            }
        }
        return cc.simplify(this, expr, mode);
    }

    public Expr toUnion(CompileContext cc) throws QueryException {
        return this.seqType().type instanceof NodeType ? cc.replaceWith(this, new Union(this.info, this.exprs)).optimize(cc) : this;
    }

    private Expr toDistinctRange() {
        long start = 0L;
        long end = 0L;
        LongList list = new LongList(2L);
        for (Expr expr : this.exprs) {
            if (expr instanceof Int) {
                list.add(((Int)expr).itr());
            } else if (expr instanceof RangeSeq) {
                list.add(((RangeSeq)expr).range(false));
            } else {
                return this;
            }
            long mn = list.get(0);
            long mx = list.peek() + 1L;
            if (start == end) {
                start = mn;
                end = mx;
            } else {
                if (mx < start - 1L || mn > end) {
                    return this;
                }
                if (mn < start) {
                    start = mn;
                }
                if (mx > end) {
                    end = mx;
                }
            }
            list.reset();
        }
        return RangeSeq.get(start, end - start, true);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new List(this.info, List.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean vacuous() {
        return ((Checks<Expr>)Expr::vacuous).all((Expr[])this.exprs);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof List && super.equals(obj);
    }

    @Override
    public String description() {
        return "list";
    }

    @Override
    public void toString(QueryString qs) {
        qs.params(this.exprs);
    }
}

