/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CachedFilter;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.IntPos;
import org.basex.query.expr.IterFilter;
import org.basex.query.expr.List;
import org.basex.query.expr.Pos;
import org.basex.query.expr.Preds;
import org.basex.query.expr.Range;
import org.basex.query.expr.SimpleFilter;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.SimplePos;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.func.Function;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Int;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class Filter
extends Preds {
    public Expr root;

    protected Filter(InputInfo info, Expr root, Expr ... preds) {
        super(info, SeqType.ITEM_ZM, preds);
        this.root = root;
    }

    public static Expr get(CompileContext cc, InputInfo ii, Expr root, Expr ... preds) throws QueryException {
        return preds.length == 0 ? root : new CachedFilter(ii, root, preds).optimize(cc);
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.root);
        super.checkUp();
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        this.root = this.root.compile(cc);
        return super.compile(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        SeqType st;
        if (this.root instanceof Filter) {
            Filter filter = (Filter)this.root;
            this.root = filter.root;
            this.exprs = (Expr[])((ExprList)((ExprList)new ExprList().add(filter.exprs)).add(this.exprs)).finish();
        }
        if ((st = this.root.seqType()).zero()) {
            return cc.replaceWith(this, this.root);
        }
        if (this.simplify(cc, this.root)) {
            return cc.emptySeq(this);
        }
        if (this.exprs.length == 0) {
            return this.root;
        }
        if (!this.mayBePositional()) {
            if (this.root instanceof ContextValue && st.type instanceof NodeType) {
                return Path.get(cc, this.info, null, Step.get(cc, this.root, this.info, this.exprs));
            }
            if (this.root instanceof AxisPath) {
                return ((AxisPath)this.root).addPredicates(cc, this.exprs);
            }
            if (st.type == NodeType.DOCUMENT_NODE && this.root.ddo()) {
                Expr step = Step.get(cc, this.root, this.info, this.exprs);
                return cc.replaceWith(this, Path.get(cc, this.info, this.root, step));
            }
            Expr expr = this.exprs[0];
            if (this.exprs.length == 1 && expr.isSimple() && !expr.seqType().mayBeNumber()) {
                Expr iff = new If(this.info, expr, this.root).optimize(cc);
                return cc.replaceWith(this, iff);
            }
            ExprList unroll = cc.unroll(this.root, false);
            if (unroll != null) {
                long last = this.root.size() - 1L;
                ExprList results = new ExprList(unroll.size());
                for (Expr ex2 : unroll) {
                    results.add(Filter.get(cc, this.info, ex2, (long)results.size() == last ? this.exprs : Arr.copyAll((CompileContext)cc, new IntObjMap(), (Expr[])this.exprs)));
                }
                return List.get(cc, this.info, (Expr[])results.finish());
            }
            return this.copyType(new IterFilter(this.info, this.root, this.exprs));
        }
        Expr expr = this.root;
        boolean opt = false;
        ExprList preds = new ExprList(this.exprs.length);
        QueryFunction<Expr, Expr> prepare = ex -> preds.isEmpty() ? ex : Filter.get(cc, this.info, ex, (Expr[])preds.next());
        for (Expr pred : this.exprs) {
            Expr ex3 = null;
            if (pred instanceof IntPos) {
                IntPos pos = (IntPos)pred;
                ex3 = cc.function(Function._UTIL_RANGE, this.info, prepare.apply(expr), Int.get(pos.min), Int.get(pos.max));
            } else if (pred instanceof SimplePos) {
                if (!((SimplePos)pred).exact()) {
                    ex3 = cc.function(Function._UTIL_RANGE, this.info, prepare.apply(expr), pred.arg(0), pred.arg(1));
                } else if (pred.arg(0).seqType().instanceOf(SeqType.INTEGER_O)) {
                    ex3 = cc.function(Function.ITEMS_AT, this.info, prepare.apply(expr), pred.arg(0));
                }
            } else if (pred instanceof Pos) {
                Expr pos = ((Pos)pred).expr;
                if (pos instanceof Range) {
                    Expr arg1 = pos.arg(0);
                    Expr arg2 = pos.arg(1);
                    if (arg1.seqType().instanceOf(SeqType.INTEGER_O) && arg1.isSimple() && Function.LAST.is(arg2)) {
                        ex3 = cc.function(Function._UTIL_RANGE, this.info, prepare.apply(expr), arg1);
                    } else if (arg1 == Int.ONE && arg2 instanceof Arith && Function.LAST.is(arg2.arg(0)) && ((Arith)arg2).calc == Calc.MINUS && arg2.arg(1) == Int.ONE) {
                        ex3 = cc.function(Function.TRUNK, this.info, prepare.apply(expr));
                    }
                }
            } else if (pred instanceof CmpG) {
                Expr op1 = pred.arg(0);
                Expr op2 = pred.arg(1);
                if (Function.POSITION.is(op1) && ((Cmp)pred).opV() == CmpV.OpV.NE && op2.seqType().instanceOf(SeqType.INTEGER_O) && op2.isSimple()) {
                    ex3 = cc.function(Function.REMOVE, this.info, prepare.apply(expr), op2);
                }
            } else if (Function.LAST.is(pred)) {
                ex3 = cc.function(Function.FOOT, this.info, prepare.apply(expr));
            } else if (pred instanceof Arith && preds.isEmpty() && Function.LAST.is(pred.arg(0))) {
                long es = expr.size();
                if (es != -1L) {
                    ex3 = cc.function(Function.ITEMS_AT, this.info, prepare.apply(expr), new Arith(this.info, Int.get(es), pred.arg(1), ((Arith)pred).calc).optimize(cc));
                }
            } else if (pred.isSimple()) {
                ANum num;
                long p;
                Expr at = null;
                if (pred.seqType().instanceOf(SeqType.INTEGER_O)) {
                    at = pred;
                } else if (pred instanceof ANum && (double)(p = (num = (ANum)pred).itr()) == num.dbl()) {
                    at = Int.get(p);
                }
                if (at != null) {
                    ex3 = cc.function(Function.ITEMS_AT, this.info, prepare.apply(expr), at);
                }
            }
            if (ex3 != null) {
                expr = ex3;
                opt = true;
                continue;
            }
            preds.add(pred);
        }
        if (opt) {
            return cc.replaceWith(this, prepare.apply(expr));
        }
        return this.copyType(this.exprs.length == 1 && this.exprs[0].isSimple() ? new SimpleFilter(this.info, this.root, this.exprs) : new CachedFilter(this.info, this.root, this.exprs));
    }

    @Override
    protected final Expr type(Expr expr) {
        this.exprType.assign(this.root.seqType().union(Occ.ZERO)).data(this.root);
        return this.root;
    }

    public final Expr addPredicate(CompileContext cc, Expr pred) throws QueryException {
        this.exprs = (Expr[])((ExprList)((Object)((ExprList)new ExprList(this.exprs.length + 1).add(this.exprs)).add(pred))).finish();
        return this.copyType(Filter.get(cc, this.info, this.root, this.exprs));
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr pred;
        Expr expr = this;
        if (mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE)) {
            expr = this.flattenEbv(this.root, true, cc);
        } else if (mode == CompileContext.Simplify.DISTINCT && !this.mayBePositional()) {
            Expr ex = this.root.simplifyFor(mode, cc);
            if (ex != this.root) {
                expr = Filter.get(cc, this.info, ex, this.exprs);
            }
        } else if (mode == CompileContext.Simplify.COUNT && this.exprs.length == 1 && (pred = this.exprs[0]).seqType().instanceOf(SeqType.NODE_ZO)) {
            expr = SimpleMap.get(cc, this.info, this.root, pred);
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public final boolean has(Flag ... flags) {
        if (Flag.FCS.in(flags) || this.root.has(flags)) {
            return true;
        }
        Flag[] flgs = Flag.FCS.remove(Flag.POS.remove(Flag.CTX.remove(flags)));
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public final boolean inlineable(InlineContext ic) {
        return this.root.inlineable(ic) && super.inlineable(ic);
    }

    @Override
    public final VarUsage count(Var var) {
        VarUsage inRoot = this.root.count(var);
        if (var == null) {
            return inRoot;
        }
        VarUsage inPreds = super.count(var);
        return inPreds == VarUsage.NEVER ? inRoot : (this.root.seqType().zeroOrOne() ? inRoot.plus(inPreds) : VarUsage.MORE_THAN_ONCE);
    }

    @Override
    public final Expr inline(InlineContext ic) throws QueryException {
        boolean changed;
        Expr inlined = this.root.inline(ic);
        boolean bl = changed = inlined != null;
        if (changed) {
            this.root = inlined;
        }
        return (changed |= ic.var != null && ic.cc.ok(this.root, () -> ic.inline(this.exprs))) ? this.optimize(ic.cc) : null;
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        for (Expr expr : this.exprs) {
            visitor.enterFocus();
            if (!expr.accept(visitor)) {
                return false;
            }
            visitor.exitFocus();
        }
        return this.root.accept(visitor);
    }

    @Override
    public boolean ddo() {
        return this.root.ddo();
    }

    @Override
    public final int exprSize() {
        int size = 1;
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size + this.root.exprSize();
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof Filter && this.root.equals(((Filter)obj).root) && super.equals(obj);
    }

    @Override
    public final void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.root, this.exprs});
    }

    @Override
    public final void toString(QueryString qs) {
        qs.token(this.root);
        super.toString(qs);
    }
}

