/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import org.basex.build.csv.CsvParserOptions;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.Token;
import org.basex.util.XMLToken;

final class CsvDirectConverter
extends CsvConverter {
    private FBuilder doc;
    private FBuilder root;
    private FBuilder record;

    CsvDirectConverter(CsvParserOptions copts) {
        super(copts);
    }

    @Override
    protected void record() {
        this.finishRecord();
        this.record = FElem.build(Q_RECORD);
        this.column = -1;
    }

    @Override
    protected void header(byte[] value) {
        this.headers.add(this.shared.token(this.attributes ? value : XMLToken.encode(value, this.lax)));
    }

    @Override
    protected void entry(byte[] value) {
        ++this.column;
        if (this.skipEmpty && value.length == 0) {
            return;
        }
        byte[] name = (byte[])this.headers.get(this.column);
        FBuilder elem = this.attributes ? FElem.build(Q_ENTRY).add(Q_NAME, name) : FElem.build(name != null ? this.shared.qname(name) : Q_ENTRY);
        this.record.add(elem.add(this.shared.token(value)));
    }

    @Override
    protected void init(String uri) {
        this.doc = FDoc.build(Token.token(uri));
        this.root = FElem.build(Q_CSV);
    }

    @Override
    protected FNode finish() {
        this.finishRecord();
        return this.doc.add(this.root).finish();
    }

    private void finishRecord() {
        if (this.record != null && !this.record.isEmpty()) {
            this.root.add(this.record);
        }
    }
}

