/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.jobs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.jobs.JobOptions;
import org.basex.core.jobs.JobsText;
import org.basex.core.jobs.QueryJob;
import org.basex.core.jobs.QueryJobSpec;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.serial.SerializerMode;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLAccess;
import org.basex.util.options.Option;

public final class Jobs {
    private static final Object FILE = new Object();
    private final ArrayList<QueryJobSpec> list = new ArrayList();
    private final Context context;
    private final IOFile file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jobs(Context context) throws IOException {
        this.context = context;
        Object object = FILE;
        synchronized (object) {
            this.file = context.soptions.dbPath(Token.string(JobsText.Q_JOBS.string()) + ".xml");
            if (!this.file.exists()) {
                return;
            }
            MainOptions options = new MainOptions(false);
            options.set(MainOptions.INTPARSE, true);
            options.set(MainOptions.STRIPWS, true);
            DBNode doc = new DBNode(Parser.singleParser(this.file, options, ""));
            ANode root = XMLAccess.children(doc, JobsText.Q_JOBS).next();
            if (root == null) {
                Util.errln(this.file + ": No '%' root element.", JobsText.Q_JOBS);
            } else {
                for (ANode child : XMLAccess.children(root)) {
                    QNm qname = child.qname();
                    if (qname.eq(JobsText.Q_JOB)) {
                        JobOptions opts = this.options(child);
                        if (opts == null) continue;
                        this.add(new QueryJobSpec(opts, new HashMap<String, Value>(), new IOContent(child.string())));
                        continue;
                    }
                    Util.errln(this.file + ": invalid element: %.", qname);
                }
            }
        }
    }

    public void init() {
        boolean error = false;
        for (int l = 0; l < this.list.size(); ++l) {
            QueryJobSpec spec = this.list.get(l);
            try {
                new QueryJob(spec, this.context, null, null, null);
                continue;
            }
            catch (QueryException ex) {
                Util.errln(ex, new Object[0]);
                this.list.remove(l);
                error = true;
            }
        }
        if (error) {
            try {
                this.write();
            }
            catch (IOException ex) {
                Util.errln(this.file + ": %", ex);
            }
        }
    }

    public void add(QueryJobSpec spec) {
        for (int l = 0; l < this.list.size(); ++l) {
            QueryJobSpec job = this.list.get(l);
            if (!job.equals(spec)) continue;
            this.list.set(l, job);
            return;
        }
        this.list.add(spec);
    }

    public void remove(String id) {
        this.list.removeIf(job -> id.equals(job.options.get(JobOptions.ID)));
    }

    private JobOptions options(ANode job) {
        JobOptions opts = new JobOptions();
        for (ANode attr : job.attributeIter()) {
            try {
                opts.assign(Token.string(attr.name()), Token.string(attr.string()));
            }
            catch (BaseXException ex) {
                Util.errln(this.file + ": Job attribute cannot be assigned: %", ex);
                return null;
            }
        }
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        Object object = FILE;
        synchronized (object) {
            if (this.list.isEmpty() && this.file.exists()) {
                this.file.delete();
                return;
            }
            this.file.parent().md();
            this.file.write(this.toXml().serialize(SerializerMode.INDENT.get()).finish());
        }
    }

    public FNode toXml() {
        FBuilder root = FElem.build(JobsText.Q_JOBS);
        for (QueryJobSpec spec : this.list) {
            FBuilder elem = FElem.build(JobsText.Q_JOB);
            for (Option<?> option : spec.options) {
                elem.add(new QNm(option.name()), spec.options.get(option));
            }
            root.add(elem.add(spec.query));
        }
        return root.finish();
    }
}

