/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.jobs.JobContext;
import org.basex.core.jobs.JobException;
import org.basex.core.jobs.JobState;
import org.basex.core.users.Perm;
import org.basex.util.Performance;

public abstract class Job {
    private final List<Job> children = Collections.synchronizedList(new ArrayList(0));
    private JobContext jc = new JobContext(this);
    private volatile Timer timer;
    public volatile boolean updating;
    public volatile JobState state = JobState.SCHEDULED;
    private volatile boolean stopped;

    public final JobContext jc() {
        return this.jc;
    }

    public final void register(Context ctx) {
        this.jc.context = ctx;
        ctx.jobs.register(this);
        this.state(JobState.QUEUED);
        ctx.locking.acquire(this, ctx);
        this.state(JobState.RUNNING);
        this.jc.performance = new Performance();
        if (!ctx.user().has(Perm.ADMIN)) {
            this.startTimeout(ctx.soptions.get(StaticOptions.TIMEOUT).intValue());
        }
    }

    public final void unregister(Context ctx) {
        this.stopTimeout();
        ctx.locking.release();
        ctx.jobs.unregister(this);
    }

    public final Job active() {
        return this.children.isEmpty() ? this : this.children.get(0).active();
    }

    public final <J extends Job> J pushJob(J job) {
        this.children.add(job);
        job.jobContext(this.jc);
        return job;
    }

    public final synchronized void popJob() {
        this.children.remove(this.children.size() - 1);
    }

    public final void stop() {
        this.state(JobState.STOPPED);
    }

    public final void timeout() {
        this.state(JobState.TIMEOUT);
    }

    public final void memory() {
        this.state(JobState.MEMORY);
    }

    public final void checkStop() {
        if (this.stopped) {
            throw new JobException(Text.INTERRUPTED);
        }
    }

    public final boolean stopped() {
        return this.stopped;
    }

    public final void state(JobState js) {
        for (Job job : this.children) {
            job.state(js);
        }
        this.state = js;
        if (js == JobState.STOPPED || js == JobState.TIMEOUT || js == JobState.MEMORY) {
            this.stopped = true;
            this.stopTimeout();
        }
    }

    public void addLocks() {
        this.jc.locks.writes.addGlobal();
    }

    public String shortInfo() {
        return Text.PLEASE_WAIT_D;
    }

    public String detailedInfo() {
        return Text.PLEASE_WAIT_D;
    }

    public double progressInfo() {
        return 0.0;
    }

    final void jobContext(JobContext ctx) {
        for (Job job : this.children) {
            job.jobContext(ctx);
        }
        this.jc = ctx;
    }

    private void startTimeout(long sec) {
        if (sec == 0L) {
            return;
        }
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Job.this.timeout();
            }
        }, sec * 1000L);
    }

    private void stopTimeout() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

