/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.HashSet;
import org.basex.core.Databases;
import org.basex.core.Datas;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.Store;
import org.basex.core.jobs.JobPool;
import org.basex.core.locks.Locking;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.core.users.Users;
import org.basex.data.Data;
import org.basex.io.random.TableDiskAccess;
import org.basex.query.util.pkg.EXPathRepo;
import org.basex.query.value.seq.DBNodes;
import org.basex.server.ClientBlocker;
import org.basex.server.ClientInfo;
import org.basex.server.Log;
import org.basex.server.Sessions;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Context {
    public final ClientBlocker blocker;
    public final JobPool jobs;
    public final MainOptions options;
    public final StaticOptions soptions;
    public final Sessions sessions;
    public final Datas datas;
    public final Users users;
    public final EXPathRepo repo;
    public final Databases databases;
    public final Log log;
    public final Locking locking;
    public final Store store;
    private final HashSet<Object> external;
    private final ClientInfo client;
    private DBNodes current;
    private User user;
    private Data data;
    private boolean closed;
    public DBNodes marked;
    public DBNodes copied;
    public int focused = -1;

    public Context() {
        this(true);
    }

    public Context(boolean file) {
        this(new StaticOptions(file));
    }

    public Context(Context ctx) {
        this(ctx, null);
    }

    public Context(Context ctx, ClientInfo client) {
        this.client = client;
        this.soptions = ctx.soptions;
        this.options = new MainOptions(ctx.options);
        this.datas = ctx.datas;
        this.sessions = ctx.sessions;
        this.databases = ctx.databases;
        this.blocker = ctx.blocker;
        this.locking = ctx.locking;
        this.users = ctx.users;
        this.repo = ctx.repo;
        this.log = ctx.log;
        this.jobs = ctx.jobs;
        this.store = ctx.store;
        this.external = new HashSet<Object>(ctx.external);
    }

    public Context(StaticOptions soptions) {
        this.soptions = soptions;
        this.options = new MainOptions();
        this.datas = new Datas();
        this.sessions = new Sessions();
        this.blocker = new ClientBlocker();
        this.databases = new Databases(soptions);
        this.locking = new Locking(soptions);
        this.users = new Users(soptions);
        this.repo = new EXPathRepo(soptions);
        this.log = new Log(soptions);
        this.user = this.users.get("admin");
        this.jobs = new JobPool(soptions);
        this.external = new HashSet();
        this.store = new Store(this);
        this.client = null;
    }

    public User user() {
        return this.user;
    }

    public void user(User us) {
        if (this.user != null) {
            throw Util.notExpected("User has already been assigned.", new Object[0]);
        }
        this.user = us;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.store.close();
        this.jobs.close();
        this.sessions.close();
        this.datas.close();
        this.log.close();
        this.closeDB();
    }

    public boolean root() {
        return this.data != null && this.current == null;
    }

    public Data data() {
        return this.data;
    }

    public DBNodes current() {
        if (this.data == null) {
            return null;
        }
        if (this.current != null) {
            return this.current;
        }
        return new DBNodes(this.data, true, this.data.resources.docs().toArray());
    }

    public void current(DBNodes curr) {
        this.current = curr.discardDocs();
    }

    public void openDB(Data dt) {
        this.data = dt;
        this.copied = null;
        this.set(null, new DBNodes(dt, new int[0]));
    }

    public void closeDB() {
        this.data = null;
        this.copied = null;
        this.set(null, null);
    }

    public void set(DBNodes curr, DBNodes mark) {
        this.current = curr;
        this.marked = mark;
        this.focused = -1;
    }

    public void invalidate() {
        this.current = null;
    }

    public boolean pinned(String db) {
        return this.datas.pinned(db) || TableDiskAccess.locked(db, this);
    }

    public boolean perm(Perm perm, String db) {
        return this.user.has(perm, db);
    }

    public String clientAddress() {
        return this.client != null ? this.client.clientAddress() : null;
    }

    public String clientName() {
        return this.client != null ? this.client.clientName() : (this.user != null ? this.user.name() : null);
    }

    public StringList listDBs() {
        return this.listDBs(null);
    }

    public StringList listDBs(String pattern) {
        StringList dbs = this.databases.listDBs(pattern);
        StringList sl = new StringList(dbs.size());
        for (String db : dbs) {
            if (!this.perm(Perm.READ, db)) continue;
            sl.add(db);
        }
        return sl;
    }

    public void setExternal(Object object) {
        this.external.add(object);
    }

    public Object getExternal(Class<?> clz) {
        for (Object object : this.external) {
            Class<?> c = object.getClass();
            if (c == clz) {
                return object;
            }
            for (Class<?> inter : c.getInterfaces()) {
                if (inter != clz) continue;
                return object;
            }
        }
        return null;
    }
}

