/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQDataSource;
import javax.xml.xquery.XQException;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.util.EmptyPrintWriter;
import net.xqj.core.util.Logger;

public abstract class GenericXQDataSource
implements XQDataSource {
    protected Properties properties = new Properties();
    protected Logger logger = Logger.newInstance(EmptyPrintWriter.getInstance());
    protected static final String DESCRIPTION = "description";
    protected static final String LOG_LEVEL = "logLevel";
    protected static final String LOGIN_TIMEOUT = "loginTimeout";
    protected static final String READ_ONLY = "readOnly";
    protected static HashSet LOG_STATUS_CODES = new HashSet<String>(Arrays.asList("FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE"));

    public GenericXQDataSource() {
        this.properties.setProperty(LOG_LEVEL, "INFO");
        this.logger.setLogLevel(3);
        this.properties.setProperty(LOGIN_TIMEOUT, "0");
        this.properties.setProperty(READ_ONLY, "false");
    }

    public abstract XQConnection getConnection() throws XQException;

    public abstract XQConnection getConnection(String var1, String var2) throws XQException;

    public abstract XQConnection getConnection(Connection var1) throws XQException;

    public void setDescription(String description) throws XQException {
        if (description == null) {
            throw new XQExceptionImpl("Can not set a null description.", "XQJDS007");
        }
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(1, description));
        }
        this.properties.setProperty(DESCRIPTION, description);
    }

    public String getDescription() {
        return this.properties.getProperty(DESCRIPTION);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLoginTimeout(int seconds) throws XQException {
        if (seconds < 0) {
            throw new XQExceptionImpl("Can not set a login timeout which is less than 0.", "XQJDS006");
        }
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(0, new Integer(seconds)));
        }
        this.properties.setProperty(LOGIN_TIMEOUT, String.valueOf(seconds));
    }

    public int getLoginTimeout() throws XQException {
        return Integer.parseInt(this.properties.getProperty(LOGIN_TIMEOUT));
    }

    public void setLogLevel(String level) throws XQException {
        if (LOG_STATUS_CODES.contains(level)) {
            switch (level.charAt(0)) {
                case 'F': {
                    this.logger.setLogLevel(0);
                    break;
                }
                case 'E': {
                    this.logger.setLogLevel(1);
                    break;
                }
                case 'W': {
                    this.logger.setLogLevel(2);
                    break;
                }
                case 'I': {
                    this.logger.setLogLevel(3);
                    break;
                }
                case 'D': {
                    this.logger.setLogLevel(4);
                    break;
                }
                case 'T': {
                    this.logger.setLogLevel(5);
                }
            }
        } else {
            throw new XQExceptionImpl("logLevel parameter must be one of " + LOG_STATUS_CODES + ".", "XQJDS001");
        }
        this.properties.setProperty(LOG_LEVEL, level);
    }

    public String getLogLevel() throws XQException {
        return this.properties.getProperty(LOG_LEVEL);
    }

    public String[] getSupportedPropertyNames() {
        return new String[]{DESCRIPTION, LOG_LEVEL, LOGIN_TIMEOUT, READ_ONLY};
    }

    public void setProperty(String name, String value) throws XQException {
        if (name == null) {
            throw new XQExceptionImpl("The name parameter can not be null.", "XQJDS004");
        }
        if (DESCRIPTION.equals(name)) {
            this.setDescription(value);
        } else if (LOG_LEVEL.equals(name)) {
            this.setLogLevel(value);
        } else if (LOGIN_TIMEOUT.equals(name)) {
            this.setLoginTimeout(Integer.parseInt(value));
        } else if (READ_ONLY.equals(name)) {
            this.setReadOnly(value);
        } else {
            throw new XQExceptionImpl("Property \"" + name + "\" is not recognised.", "XQJDS005");
        }
    }

    public String getProperty(String name) throws XQException {
        if (name == null) {
            throw new XQExceptionImpl("name parameter can not be null.", "XQJDS003");
        }
        if (DESCRIPTION.equals(name) || LOG_LEVEL.equals(name) || LOGIN_TIMEOUT.equals(name) || READ_ONLY.equals(name)) {
            return this.properties.getProperty(name);
        }
        throw new XQException("Property \"" + name + "\" is not recognised.");
    }

    public void setProperties(Properties props) throws XQException {
        if (props == null) {
            throw new XQExceptionImpl("Properties argument can not be null.", "XQJDS002");
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            this.setProperty(name, props.getProperty(name));
        }
    }

    public void setLogWriter(PrintWriter out) throws XQException {
        if (out == null) {
            out = EmptyPrintWriter.getInstance();
        }
        this.logger.setPrintWriter(out);
    }

    public PrintWriter getLogWriter() throws XQException {
        if (this.logger.getPrintWriter() == EmptyPrintWriter.getInstance()) {
            return null;
        }
        return this.logger.getPrintWriter();
    }

    public void setReadOnly(String readOnly) throws XQException {
        this.setReadOnly(XQToolkit.getBooleanFromString(readOnly, this.getReadOnly()));
    }

    public void setReadOnly(boolean readOnly) throws XQException {
        this.properties.setProperty(READ_ONLY, String.valueOf(readOnly));
    }

    public boolean getReadOnly() throws XQException {
        return Boolean.valueOf(this.properties.getProperty(READ_ONLY));
    }
}

