/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.list.FloatList;

public final class FltSeq
extends NativeSeq {
    private final float[] values;

    private FltSeq(float[] values) {
        super(values.length, (Type)AtomType.FLOAT);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException, QueryException {
        int size = in.readNum();
        float[] values = new float[size];
        for (int s = 0; s < size; ++s) {
            values[s] = Flt.parse(in.readToken(), null);
        }
        return FltSeq.get(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        float[] fArray = this.values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double v = fArray[i];
            out.writeToken(Token.token(v));
        }
    }

    @Override
    public Flt itemAt(long pos) {
        return Flt.get(this.values[(int)pos]);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        float[] tmp = new float[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return FltSeq.get(tmp);
    }

    public float[] toJava() {
        return this.values;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof FltSeq ? Arrays.equals(this.values, ((FltSeq)obj).values) : super.equals(obj));
    }

    public static Value get(float[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Flt.get(values[0]) : new FltSeq(values));
    }

    static Value get(int size, Value ... values) throws QueryException {
        FloatList tmp = new FloatList(size);
        for (Value value : values) {
            if (value instanceof FltSeq) {
                tmp.add(((FltSeq)value).values);
                continue;
            }
            for (Item item : value) {
                tmp.add(item.flt(null));
            }
        }
        return FltSeq.get(tmp.finish());
    }
}

