/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.regex.Matcher;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ADateDur;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class DTDur
extends Dur {
    public DTDur(Dur dur) {
        super(AtomType.DAY_TIME_DURATION);
        this.sec = dur.sec == null ? BigDecimal.ZERO : dur.sec;
    }

    public DTDur(long hours, long minutes) {
        super(AtomType.DAY_TIME_DURATION);
        this.sec = BigDecimal.valueOf(hours).multiply(Dec.BD_60).add(BigDecimal.valueOf(minutes)).multiply(Dec.BD_60);
    }

    public DTDur(BigDecimal sec) {
        super(AtomType.DAY_TIME_DURATION);
        this.sec = sec;
    }

    public DTDur(byte[] value, InputInfo ii) throws QueryException {
        super(AtomType.DAY_TIME_DURATION);
        String val = Token.string(value).trim();
        Matcher mt = DTD.matcher(val);
        if (!mt.matches() || Strings.endsWith(val, 'P') || Strings.endsWith(val, 'T')) {
            throw this.dateError(value, "P23DT12M34S", ii);
        }
        this.dayTime(value, mt, 2, ii);
    }

    public DTDur(DTDur dur, DTDur add, boolean plus, InputInfo ii) throws QueryException {
        this(dur);
        this.sec = plus ? this.sec.add(add.sec) : this.sec.subtract(add.sec);
        double d = this.sec.doubleValue();
        if (d <= -9.223372036854776E18 || d >= 9.223372036854776E18) {
            throw QueryError.SECDURRANGE_X.get(ii, d);
        }
    }

    public DTDur(Dur dur, double factor, boolean mult, InputInfo ii) throws QueryException {
        this(dur);
        if (Double.isNaN(factor)) {
            throw QueryError.DATECALC_X_X.get(ii, this.description(), factor);
        }
        if (mult ? Double.isInfinite(factor) : factor == 0.0) {
            throw QueryError.DATEZERO_X_X.get(ii, this.type, factor);
        }
        if (mult ? factor == 0.0 : Double.isInfinite(factor)) {
            this.sec = BigDecimal.ZERO;
        } else {
            BigDecimal d = BigDecimal.valueOf(factor);
            try {
                this.sec = mult ? this.sec.multiply(d) : this.sec.divide(d, MathContext.DECIMAL64);
            }
            catch (ArithmeticException ex) {
                Util.debug(ex);
                d = BigDecimal.valueOf(1.0 / factor);
                BigDecimal bigDecimal = this.sec = mult ? this.sec.divide(d, MathContext.DECIMAL64) : this.sec.multiply(d);
            }
        }
        if (Math.abs(this.sec.doubleValue()) < 1.0E-13) {
            this.sec = BigDecimal.ZERO;
        }
    }

    public DTDur(ADate date, ADate sub, InputInfo ii) throws QueryException {
        super(AtomType.DAY_TIME_DURATION);
        this.sec = date.days().subtract(sub.days()).multiply(Dec.BD_864000).add(date.seconds().subtract(sub.seconds()));
        double d = this.sec.doubleValue();
        if (d <= -9.223372036854776E18 || d >= 9.223372036854776E18) {
            throw QueryError.SECRANGE_X.get(ii, d);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeToken(this.string(null));
    }

    public BigDecimal dtd() {
        return this.sec;
    }

    @Override
    public byte[] string(InputInfo ii) {
        TokenBuilder tb = new TokenBuilder();
        int ss = this.sec.signum();
        if (ss < 0) {
            tb.add(45);
        }
        tb.add(80);
        if (this.day() != 0L) {
            tb.addLong(Math.abs(this.day()));
            tb.add(68);
        }
        this.time(tb);
        if (ss == 0) {
            tb.add("T0S");
        }
        return tb.finish();
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        if (item.type == this.type) {
            return this.sec.subtract(((ADateDur)item).sec).signum();
        }
        throw QueryError.diffError(item, this, ii);
    }

    public static DTDur get(long ms) {
        return new DTDur(BigDecimal.valueOf(ms).divide(Dec.BD_1000, MathContext.DECIMAL64));
    }
}

