/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.DeepEqualOptions;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ADateDur;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public abstract class ADate
extends ADateDur {
    static final long MAX_YEAR = 25252734927766554L;
    static final long MIN_YEAR = -25252734927766554L;
    private static final long ADD_NEG = 25252734927766800L;
    static final String DD = "(\\d{2})";
    static final String YEAR = "(-?(000[1-9]|00[1-9]\\d|0[1-9]\\d{2}|[1-9]\\d{3,}))";
    static final String ZONE = "(([-+])(\\d{2}):(\\d{2})|Z)?";
    static final byte[] DAYS = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final Pattern DATE = Pattern.compile("(-?(000[1-9]|00[1-9]\\d|0[1-9]\\d{2}|[1-9]\\d{3,}))-(\\d{2})-(\\d{2})(([-+])(\\d{2}):(\\d{2})|Z)?");
    public static final Pattern TIME = Pattern.compile("(\\d{2}):(\\d{2}):(\\d{2}(\\.\\d+)?)(([-+])(\\d{2}):(\\d{2})|Z)?");
    long yea = Long.MAX_VALUE;
    byte mon = (byte)-1;
    byte day = (byte)-1;
    byte hou = (byte)-1;
    byte min = (byte)-1;
    short tz = Short.MAX_VALUE;
    static final DatatypeFactory DF;

    ADate(Type type, ADate date) {
        super(type);
        this.yea = date.yea;
        this.mon = date.mon;
        this.day = date.day;
        this.hou = date.hou;
        this.min = date.min;
        this.sec = date.sec;
        this.tz = date.tz;
    }

    ADate(Type type) {
        super(type);
    }

    final void date(byte[] date, String exp, InputInfo ii) throws QueryException {
        Matcher mt = DATE.matcher(Token.string(date).trim());
        if (!mt.matches()) {
            throw this.dateError(date, exp, ii);
        }
        this.yea = this.toLong(mt.group(1), false, ii);
        if (this.yea < 0L) {
            ++this.yea;
        }
        this.mon = (byte)(Strings.toInt(mt.group(3)) - 1);
        this.day = (byte)(Strings.toInt(mt.group(4)) - 1);
        if (this.mon < 0 || this.mon >= 12 || this.day < 0 || this.day >= ADate.dpm(this.yea, this.mon)) {
            throw this.dateError(date, exp, ii);
        }
        if (this.yea <= -25252734927766554L || this.yea > 25252734927766554L) {
            throw QueryError.DATERANGE_X_X.get(ii, this.type, date);
        }
        this.zone(mt, 5, date, ii);
    }

    final void time(byte[] time, String exp, InputInfo ii) throws QueryException {
        Matcher mt = TIME.matcher(Token.string(time).trim());
        if (!mt.matches()) {
            throw this.dateError(time, exp, ii);
        }
        this.hou = (byte)Strings.toInt(mt.group(1));
        this.min = (byte)Strings.toInt(mt.group(2));
        this.sec = this.toDecimal(mt.group(3), false, ii);
        if (this.min >= 60 || this.sec.compareTo(Dec.BD_60) >= 0 || this.hou > 24 || this.hou == 24 && (this.min > 0 || this.sec.compareTo(BigDecimal.ZERO) > 0)) {
            throw this.dateError(time, exp, ii);
        }
        this.zone(mt, 5, time, ii);
        if (this.hou == 24) {
            this.hou = 0;
            this.add(Dec.BD_864000);
        }
    }

    final void zone(Matcher matcher, int pos, byte[] value, InputInfo ii) throws QueryException {
        String z = matcher.group(pos);
        if (z == null) {
            return;
        }
        if ("Z".equals(z)) {
            this.tz = 0;
        } else {
            int th = Strings.toInt(matcher.group(pos + 2));
            int tm = Strings.toInt(matcher.group(pos + 3));
            if (th > 14 || tm > 59 || th == 14 && tm != 0) {
                throw QueryError.INVALIDZONE_X.get(ii, new Object[]{value});
            }
            int mn = th * 60 + tm;
            this.tz = (short)("-".equals(matcher.group(pos + 1)) ? -mn : mn);
        }
    }

    final void calc(DTDur dur, boolean plus) {
        this.add(plus ? dur.sec : dur.sec.negate());
    }

    final void calc(YMDur dur, boolean plus, InputInfo ii) throws QueryException {
        long m = plus ? dur.mon : -dur.mon;
        long mn = (long)this.mon + m;
        this.mon = (byte)ADate.mod(mn, 12);
        this.yea += ADate.div(mn, 12);
        this.day = (byte)Math.min(ADate.dpm(this.yea, this.mon) - 1, this.day);
        if (this.yea <= -25252734927766554L || this.yea > 25252734927766554L) {
            throw QueryError.YEARRANGE_X.get(ii, this.yea);
        }
    }

    private void add(BigDecimal add) {
        BigDecimal sc = this.sec().add(add);
        this.sec = sc.signum() >= 0 ? sc.remainder(Dec.BD_60) : sc.negate().add(sc.remainder(Dec.BD_60)).add(Dec.BD_60).add(sc).remainder(Dec.BD_60);
        long mn = Math.max(this.minute(), 0L) + ADate.div(sc.setScale(0, RoundingMode.FLOOR).longValue(), 60);
        this.min = (byte)ADate.mod(mn, 60);
        long ho = (long)Math.max(this.hou, 0) + ADate.div(mn, 60);
        this.hou = (byte)ADate.mod(ho, 24);
        long da = ADate.div(ho, 24);
        long[] ymd = ADate.ymd(this.days().add(BigDecimal.valueOf(da)));
        this.yea = ymd[0];
        this.mon = (byte)ymd[1];
        this.day = (byte)ymd[2];
    }

    private static long mod(long value, int mod) {
        return (value > 0L ? value : Long.MAX_VALUE / (long)mod * (long)mod + value) % (long)mod;
    }

    private static long div(long value, int div) {
        return value < 0L ? (value + 1L) / (long)div - 1L : value / (long)div;
    }

    public void timeZone(DTDur dur, boolean undefined, InputInfo ii) throws QueryException {
        int t;
        if (undefined) {
            t = Short.MAX_VALUE;
        } else {
            if (dur == null) {
                Calendar c = Calendar.getInstance();
                t = (short)((c.get(15) + c.get(16)) / 60000);
            } else {
                t = (short)(dur.minute() + dur.hour() * 60L);
                if (dur.sec().signum() != 0) {
                    throw QueryError.ZONESEC_X.get(ii, dur);
                }
                if (Math.abs(t) > 840 || dur.day() != 0L) {
                    throw QueryError.INVALZONE_X.get(ii, dur);
                }
            }
            if (this.tz != Short.MAX_VALUE) {
                this.add(BigDecimal.valueOf(60L * (long)(t - this.tz)));
            }
        }
        this.tz = (short)t;
    }

    @Override
    public final long yea() {
        return this.yea > 0L ? this.yea : this.yea - 1L;
    }

    @Override
    public final long mon() {
        return this.mon + 1;
    }

    @Override
    public final long day() {
        return this.day + 1;
    }

    @Override
    public final long hour() {
        return this.hou;
    }

    @Override
    public final long minute() {
        return this.min;
    }

    @Override
    public final BigDecimal sec() {
        return this.sec == null ? BigDecimal.ZERO : this.sec;
    }

    public final int tz() {
        return this.tz;
    }

    public final boolean hasTz() {
        return this.tz != Short.MAX_VALUE;
    }

    @Override
    public byte[] string(InputInfo ii) {
        boolean ymd;
        TokenBuilder tb = new TokenBuilder();
        boolean bl = ymd = this.yea != Long.MAX_VALUE;
        if (ymd) {
            if (this.yea <= 0L) {
                tb.add(45);
            }
            ADate.prefix(tb, Math.abs(this.yea()), 4);
            tb.add(45);
            ADate.prefix(tb, this.mon(), 2);
            tb.add(45);
            ADate.prefix(tb, this.day(), 2);
        }
        if (this.hou >= 0) {
            if (ymd) {
                tb.add(84);
            }
            ADate.prefix(tb, this.hour(), 2);
            tb.add(58);
            ADate.prefix(tb, this.minute(), 2);
            tb.add(58);
            if (this.sec.intValue() < 10) {
                tb.add(48);
            }
            tb.add(Token.chopNumber(Token.token(this.sec().abs().toPlainString())));
        }
        this.zone(tb);
        return tb.finish();
    }

    void zone(TokenBuilder tb) {
        if (this.tz == Short.MAX_VALUE) {
            return;
        }
        if (this.tz == 0) {
            tb.add(90);
        } else {
            tb.add(this.tz > 0 ? 43 : 45);
            ADate.prefix(tb, Math.abs(this.tz) / 60, 2);
            tb.add(58);
            ADate.prefix(tb, Math.abs(this.tz) % 60, 2);
        }
    }

    static void prefix(TokenBuilder tb, long number, int zero) {
        byte[] t = Token.token(number);
        for (int i = t.length; i < zero; ++i) {
            tb.add(48);
        }
        tb.add(t);
    }

    @Override
    public final boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        return this.df(item, ii) == 0;
    }

    @Override
    public boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        return this.comparable(item) && this.eq(item, deep.coll, null, deep.info) && (deep.options.get(DeepEqualOptions.TIMEZONES) == false || this.tz == ((ADate)item).tz);
    }

    @Override
    public final boolean atomicEqual(Item item, InputInfo ii) throws QueryException {
        return item instanceof ADate && this.eq(item, null, null, ii) && this.hasTz() == ((ADate)item).hasTz();
    }

    private int df(Item item, InputInfo ii) throws QueryException {
        ADate d = (ADate)(item instanceof ADate ? item : this.type.cast(item, null, null, ii));
        BigDecimal d1 = this.seconds().add(this.days().multiply(Dec.BD_864000));
        BigDecimal d2 = d.seconds().add(d.days().multiply(Dec.BD_864000));
        return d1.compareTo(d2);
    }

    @Override
    public final int hash(InputInfo ii) {
        return this.seconds().add(this.days().multiply(Dec.BD_864000)).intValue();
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        return this.df(item, ii);
    }

    @Override
    public final XMLGregorianCalendar toJava() {
        return DF.newXMLGregorianCalendar(this.yea == Long.MAX_VALUE ? null : BigInteger.valueOf(this.yea > 0L ? this.yea : this.yea - 1L), this.mon >= 0 ? this.mon + 1 : Integer.MIN_VALUE, this.day >= 0 ? this.day + 1 : Integer.MIN_VALUE, this.hou >= 0 ? (int)this.hou : Integer.MIN_VALUE, this.min >= 0 ? (int)this.min : Integer.MIN_VALUE, this.sec != null ? this.sec.intValue() : Integer.MIN_VALUE, this.sec != null ? this.sec.remainder(BigDecimal.ONE) : null, this.tz == Short.MAX_VALUE ? Integer.MIN_VALUE : (int)this.tz);
    }

    public final BigDecimal seconds() {
        int z = this.tz;
        if (z == Short.MAX_VALUE) {
            long n = System.currentTimeMillis();
            z = Calendar.getInstance().getTimeZone().getOffset(n) / 60000;
        }
        return (this.sec == null ? BigDecimal.ZERO : this.sec).add(BigDecimal.valueOf((long)Math.max(0, this.hou) * 3600L + (long)Math.max(0, this.min) * 60L - (long)z * 60L));
    }

    final BigDecimal days() {
        long y = this.yea == Long.MAX_VALUE ? 1L : this.yea;
        return ADate.days(y + 25252734927766800L, Math.max(this.mon, 0), Math.max(this.day, 0));
    }

    private static BigDecimal days(long year, int month, int day) {
        long y = year - (long)(month < 2 ? 1 : 0);
        long m = month + (month < 2 ? 13 : 1);
        long d = day + 1;
        return Dec.BD_365.multiply(BigDecimal.valueOf(y)).add(BigDecimal.valueOf(y / 4L - y / 100L + y / 400L - 92L + d + (153L * m - 2L) / 5L));
    }

    private static long[] ymd(BigDecimal days) {
        BigDecimal d = days;
        BigDecimal t = d.add(Dec.BD_36525).multiply(Dec.BD_4).divideToIntegralValue(Dec.BD_146097).subtract(BigDecimal.ONE);
        BigDecimal y = Dec.BD_100.multiply(t);
        d = d.subtract(Dec.BD_36524.multiply(t).add(t.divideToIntegralValue(Dec.BD_4)));
        t = d.add(Dec.BD_366).multiply(Dec.BD_4).divideToIntegralValue(Dec.BD_1461).subtract(BigDecimal.ONE);
        y = y.add(t);
        d = d.subtract(Dec.BD_365.multiply(t).add(t.divideToIntegralValue(Dec.BD_4)));
        BigDecimal m = Dec.BD_5.multiply(d).add(Dec.BD_2).divideToIntegralValue(Dec.BD_153);
        d = d.subtract(Dec.BD_153.multiply(m).add(Dec.BD_2).divideToIntegralValue(Dec.BD_5));
        long mm = m.longValue();
        if (mm > 9L) {
            mm -= 12L;
            y = y.add(BigDecimal.ONE);
        }
        return new long[]{y.subtract(BigDecimal.valueOf(25252734927766800L)).longValue(), mm + 2L, d.longValue()};
    }

    public static int dpm(long yea, int mon) {
        int l = DAYS[mon];
        return mon == 1 && yea % 4L == 0L && (yea % 100L != 0L || yea % 400L == 0L) ? l + 1 : l;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ADate)) {
            return false;
        }
        ADate a = (ADate)obj;
        return this.type.eq(a.type) && this.yea == a.yea && this.mon == a.mon && this.day == a.day && this.hou == a.hou && this.min == a.min && this.tz == a.tz && (this.sec == null ? a.sec == null : this.sec.compareTo(a.sec) == 0);
    }

    @Override
    public final void toString(QueryString qs) {
        qs.quoted(this.string(null));
    }

    static {
        try {
            DF = DatatypeFactory.newInstance();
        }
        catch (Exception ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }
}

