/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.regex.parse;

import java.util.ArrayList;
import java.util.List;
import org.basex.query.util.regex.BackRef;
import org.basex.query.util.regex.Branch;
import org.basex.query.util.regex.CharClass;
import org.basex.query.util.regex.CharGroup;
import org.basex.query.util.regex.CharRange;
import org.basex.query.util.regex.Disjunction;
import org.basex.query.util.regex.Escape;
import org.basex.query.util.regex.Group;
import org.basex.query.util.regex.LineBorder;
import org.basex.query.util.regex.Literal;
import org.basex.query.util.regex.Piece;
import org.basex.query.util.regex.Quantifier;
import org.basex.query.util.regex.RegExp;
import org.basex.query.util.regex.RegExpList;
import org.basex.query.util.regex.Wildcard;
import org.basex.query.util.regex.parse.ParseException;
import org.basex.query.util.regex.parse.RegExLexer;
import org.basex.query.util.regex.parse.RegExParserConstants;
import org.basex.query.util.regex.parse.Token;
import org.basex.query.util.regex.parse.TokenManager;
import org.basex.util.BitArray;

public class RegExParser
implements RegExParserConstants {
    private int groups;
    private int backref;
    private final BitArray closed = new BitArray();
    private boolean dotAll;
    private boolean multiLine;
    public TokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[18];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public RegExParser(byte[] regex, boolean strip, boolean all, boolean multi) {
        this(new RegExLexer(regex, strip));
        this.dotAll = all;
        this.multiLine = multi;
    }

    public final int groups() {
        return this.groups;
    }

    public final RegExp parse() throws ParseException {
        RegExp regex = this.regExp();
        this.jj_consume_token(0);
        return regex;
    }

    public final RegExp regExp() throws ParseException {
        RegExpList brs = new RegExpList();
        brs.add(this.branch());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(1);
            brs.add(this.branch());
        }
        return brs.size() == 1 ? (RegExp)brs.get(0) : new Disjunction((RegExp[])brs.finish());
    }

    public final RegExp branch() throws ParseException {
        RegExpList pieces = new RegExpList();
        Quantifier qu = null;
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block6;
                }
            }
            RegExp atom = this.atom();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    qu = this.quantifier();
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                }
            }
            pieces.add(qu == null ? atom : new Piece(atom, qu));
            qu = null;
        }
        return pieces.size() == 1 ? (RegExp)pieces.get(0) : new Branch((RegExp[])pieces.finish());
    }

    public final Quantifier quantifier() throws ParseException {
        int min = 0;
        int max = 0;
        boolean lazy = false;
        int[] qu = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                max = 1;
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                max = -1;
                break;
            }
            case 4: {
                this.jj_consume_token(4);
                min = 1;
                max = -1;
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                qu = this.quantity();
                min = qu[0];
                max = qu[1];
                this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                lazy = true;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        return new Quantifier(min, max, lazy);
    }

    public final int[] quantity() throws ParseException {
        int[] qty = new int[2];
        this.jj_consume_token(7);
        try {
            qty[0] = qty[1] = Integer.parseInt((String)this.token.getValue());
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Number in quantifier is too large");
        }
        block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                qty[1] = -1;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        try {
                            qty[1] = Integer.parseInt((String)this.token.getValue());
                        }
                        catch (NumberFormatException ex) {
                            throw new ParseException("Number in quantifier is too large");
                        }
                        if (qty[0] <= qty[1]) break block2;
                        throw new ParseException("Illegal quantifier: " + qty[0] + " > " + qty[1]);
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        break;
                    }
                }
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        return qty;
    }

    public final RegExp atom() throws ParseException {
        RegExp nd = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                nd = this.Char();
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                nd = this.charClass();
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                nd = this.regExp();
                this.jj_consume_token(10);
                nd = new Group(nd, false);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                int grp = ++this.groups;
                nd = this.regExp();
                this.jj_consume_token(10);
                this.closed.set(grp);
                nd = new Group(nd, true);
                break;
            }
            case 14: {
                nd = this.backReference();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return nd;
    }

    public final Literal Char() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new Literal(this.token.image.codePointAt(0));
    }

    public final BackRef backReference() throws ParseException {
        Token tok = this.jj_consume_token(14);
        this.backref = this.token.image.charAt(1) - 48;
        while (this.jj_2_1(1) && 10 * this.backref + this.token.next.image.charAt(0) - 48 <= this.groups) {
            this.jj_consume_token(13);
            this.backref = 10 * this.backref + this.token.image.charAt(0) - 48;
        }
        if (!this.closed.get(this.backref)) {
            throw new ParseException("Illegal back-reference: \\" + this.backref);
        }
        return new BackRef(this.backref);
    }

    public final RegExp charClass() throws ParseException {
        RegExp nd = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 19: 
            case 20: {
                nd = this.charClassEsc();
                break;
            }
            case 21: {
                nd = this.charClassExpr();
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                nd = Wildcard.get(this.dotAll);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                nd = LineBorder.get(true, this.multiLine);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                nd = LineBorder.get(false, this.multiLine);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return nd;
    }

    public final RegExp charClassEsc() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        RegExp esc = Escape.get(this.token.image);
        if (esc == null) {
            throw new ParseException("Unknown escape: " + this.token);
        }
        return esc;
    }

    public final CharClass charClassExpr() throws ParseException {
        CharGroup group = null;
        CharClass sub = null;
        this.jj_consume_token(21);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                group = this.posCharGroup();
                group.negative = true;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                if (this.jj_2_2(1)) {
                    group = this.posCharGroup();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                sub = this.charClassExpr();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(24);
        return new CharClass(group, sub);
    }

    public final CharGroup posCharGroup() throws ParseException {
        RegExpList cg = new RegExpList();
        RegExp sub = null;
        block8: do {
            if (this.jj_2_3(3)) {
                sub = this.charRange();
                cg.add(sub);
                continue;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 19: 
                case 20: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 18: {
                            this.jj_consume_token(18);
                            break;
                        }
                        case 19: {
                            this.jj_consume_token(19);
                            break;
                        }
                        case 20: {
                            this.jj_consume_token(20);
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    for (RegExp re : Escape.inGroup(this.token.image)) {
                        cg.add(re);
                    }
                    continue block8;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        } while (this.jj_2_4(1));
        return new CharGroup((RegExp[])cg.finish());
    }

    public final RegExp charRange() throws ParseException {
        int a = -1;
        int b = -1;
        if (this.getToken((int)2).kind == 12 && "-".equals(this.getToken((int)2).image)) {
            a = this.charOrEsc();
            this.jj_consume_token(12);
            b = this.charOrEsc();
            if (a > b) {
                throw new ParseException("Illegal range: " + Literal.escape(a) + " > " + Literal.escape(b));
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: 
                case 13: {
                    a = this.XmlChar();
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return b == -1 ? new Literal(a) : new CharRange(a, b);
    }

    public final int charOrEsc() throws ParseException {
        int cp = -1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                cp = this.XmlChar();
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                cp = Escape.getCp(this.token.image);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cp;
    }

    public final int XmlChar() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.codePointAt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    private boolean jj_3R_12() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_13()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_5();
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(20)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_3R_6();
    }

    private boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_7()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_9() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_5() {
        Token xsp;
        if (this.jj_3_4()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_4());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_8() {
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(13);
    }

    private boolean jj_3R_6() {
        Token xsp = this.jj_scanpos;
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 12 && "-".equals(this.getToken((int)2).image);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_9()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_13() {
        return this.jj_scan_token(18);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{2, 4192768, 60, 60, 4, 128, 256, 4192768, 12288, 4161536, 0x1C0000, 0x400000, 0x800000, 0x1C0000, 0x1C0000, 12288, 274432, 12288};
    }

    public RegExParser(TokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(TokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[25];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 18; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 25; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        RegExParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

