/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.fingertree;

import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.query.util.fingertree.PartialInnerNode;
import org.basex.util.Array;

final class InnerNode<N, E>
implements Node<Node<N, E>, E> {
    final Node<N, E>[] children;
    final long[] bounds;

    InnerNode(Node<N, E>[] children) {
        int n = children.length;
        this.children = children;
        this.bounds = new long[n];
        long off = 0L;
        for (int i = 0; i < n; ++i) {
            this.bounds[i] = off += children[i].size();
        }
        assert (2 <= n && n <= 4);
    }

    @Override
    public long size() {
        return this.bounds[this.bounds.length - 1];
    }

    @Override
    public int arity() {
        return this.bounds.length;
    }

    @Override
    public Node<N, E> getSub(int pos) {
        return this.children[pos];
    }

    @Override
    public InnerNode<N, E> reverse() {
        int n = this.children.length;
        Node[] newChildren = new Node[n];
        for (int i = 0; i < n; ++i) {
            newChildren[i] = this.children[n - 1 - i].reverse();
        }
        return new InnerNode<N, E>(newChildren);
    }

    @Override
    public InnerNode<N, E> set(long pos, E val) {
        int i = 0;
        while (pos >= this.bounds[i]) {
            ++i;
        }
        long p = i == 0 ? pos : pos - this.bounds[i - 1];
        Node[] ch = (Node[])this.children.clone();
        ch[i] = this.children[i].set(p, val);
        return new InnerNode<N, E>(ch);
    }

    @Override
    public boolean insert(Node<Node<N, E>, E>[] siblings, long index, E val) {
        int ra;
        int la;
        int move;
        InnerNode<N, E> left = siblings[0];
        InnerNode<N, E> right = siblings[2];
        int i = 0;
        int n = this.bounds.length;
        while (index > this.bounds[i]) {
            ++i;
        }
        long off = i == 0 ? index : index - this.bounds[i - 1];
        Node<Node<N, E>, E>[] subs = siblings;
        subs[0] = i == 0 ? null : this.children[i - 1];
        subs[2] = i == n - 1 ? null : this.children[i + 1];
        int l = Math.max(0, i - 1);
        int r = Math.min(i + 1, n - 1);
        if (!this.children[i].insert(subs, off, val)) {
            Node[] out = (Node[])this.children.clone();
            Array.copy(subs, i == 0 ? 1 : 0, r - l + 1, out, l);
            siblings[0] = left;
            siblings[1] = new InnerNode<N, E>(out);
            siblings[2] = right;
            return false;
        }
        Node[] temp = new Node[n + 1];
        if (i == 0) {
            Array.copyToStart(subs, 1, 3, temp);
            Array.copy(this.children, 2, n - 2, temp, 3);
        } else if (i < n - 1) {
            Array.copy(this.children, l, temp);
            Array.copyFromStart(subs, 4, temp, l);
            Array.copy(this.children, r + 1, n - l - 3, temp, l + 4);
        } else {
            Array.copy(this.children, n - 2, temp);
            Array.copyFromStart(subs, 3, temp, n - 2);
        }
        if (n < 4) {
            siblings[0] = left;
            siblings[1] = new InnerNode<N, E>(temp);
            siblings[2] = right;
            return false;
        }
        if (left != null && (move = (4 - (la = left.arity()) + 1) / 2) > 0) {
            Node<N, E>[] ch = ((InnerNode)left).children;
            Node[] ls = new Node[la + move];
            Node[] rs = new Node[n + 1 - move];
            Array.copy(ch, la, ls);
            Array.copyFromStart(temp, move, ls, la);
            Array.copyToStart(temp, move, rs.length, rs);
            siblings[0] = new InnerNode<N, E>(ls);
            siblings[1] = new InnerNode<N, E>(rs);
            siblings[2] = right;
            return false;
        }
        if (right != null && (move = (4 - (ra = right.arity()) + 1) / 2) > 0) {
            Node<N, E>[] ch = ((InnerNode)right).children;
            Node[] ls = new Node[n + 1 - move];
            Node[] rs = new Node[ra + move];
            Array.copy(temp, ls.length, ls);
            Array.copyToStart(temp, ls.length, move, rs);
            Array.copyFromStart(ch, ra, rs, move);
            siblings[0] = left;
            siblings[1] = new InnerNode<N, E>(ls);
            siblings[2] = new InnerNode<N, E>(rs);
            return false;
        }
        if (left != null) {
            Node<N, E>[] ch = ((InnerNode)left).children;
            int la2 = ch.length;
            int k = la2 + n + 1;
            int ml = k / 3;
            int ll = k - 2 * ml;
            int inL = la2 - ll;
            Node[] ls = new Node[ll];
            Node[] mid1 = new Node[ml];
            Node[] mid2 = new Node[ml];
            Array.copy(ch, ll, ls);
            Array.copyToStart(ch, ll, inL, mid1);
            Array.copyFromStart(temp, ml - inL, mid1, inL);
            Array.copyToStart(temp, ml - inL, ml, mid2);
            siblings[0] = inL == 0 ? left : new InnerNode<N, E>(ls);
            siblings[1] = new InnerNode<N, E>(mid1);
            siblings[2] = new InnerNode<N, E>(mid2);
            siblings[3] = right;
            return true;
        }
        if (right != null) {
            Node<N, E>[] ch = ((InnerNode)right).children;
            int ra2 = ch.length;
            int k = n + 1 + ra2;
            int ml = k / 3;
            int rl = k - 2 * ml;
            int inR = ra2 - rl;
            Node[] mid1 = new Node[ml];
            Node[] mid2 = new Node[ml];
            Node[] rs = new Node[rl];
            Array.copy(temp, ml, mid1);
            Array.copyToStart(temp, ml, ml - inR, mid2);
            Array.copyFromStart(ch, inR, mid2, ml - inR);
            Array.copyToStart(ch, inR, rl, rs);
            siblings[0] = null;
            siblings[1] = new InnerNode<N, E>(mid1);
            siblings[2] = new InnerNode<N, E>(mid2);
            siblings[3] = inR == 0 ? right : new InnerNode<N, E>(rs);
            return true;
        }
        int ll = (n + 1) / 2;
        int rl = n + 1 - ll;
        Node[] ls = new Node[ll];
        Node[] rs = new Node[rl];
        Array.copy(temp, ll, ls);
        Array.copyToStart(temp, ll, rl, rs);
        siblings[0] = null;
        siblings[1] = new InnerNode<N, E>(ls);
        siblings[2] = new InnerNode<N, E>(rs);
        siblings[3] = null;
        return true;
    }

    @Override
    public NodeLike<Node<N, E>, E>[] remove(Node<Node<N, E>, E> left, Node<Node<N, E>, E> right, long pos) {
        Node single;
        NodeLike<N, E>[] res;
        int i = 0;
        int n = this.bounds.length;
        while (pos >= this.bounds[i]) {
            ++i;
        }
        long off = i == 0 ? pos : pos - this.bounds[i - 1];
        NodeLike<N, E>[] out = res = this.children[i].remove(i == 0 ? null : this.children[i - 1], i == n - 1 ? null : this.children[i + 1], off);
        Node l = (Node)res[0];
        Node m = (Node)res[1];
        Node r = (Node)res[2];
        if (m != null) {
            Node[] ch = (Node[])this.children.clone();
            if (i > 0) {
                ch[i - 1] = l;
            }
            ch[i] = m;
            if (i < n - 1) {
                ch[i + 1] = r;
            }
            out[0] = left;
            out[1] = new InnerNode<N, E>(ch);
            out[2] = right;
            return out;
        }
        if (n > 2) {
            Node[] ch = new Node[n - 1];
            if (i > 0) {
                Array.copy(this.children, i - 1, ch);
                ch[i - 1] = l;
            }
            if (i < n - 1) {
                ch[i] = r;
                Array.copy(this.children, i + 2, n - i - 2, ch, i + 1);
            }
            out[0] = left;
            out[1] = new InnerNode<N, E>(ch);
            out[2] = right;
            return out;
        }
        Node node = single = i == 0 ? r : l;
        if (left != null && left.arity() > 2) {
            Node<N, E>[] ch = ((InnerNode)left).children;
            int a = ch.length;
            int move = (a - 1) / 2;
            Node[] ls = new Node[a - move];
            Node[] ms = new Node[move + 1];
            Array.copy(ch, a - move, ls);
            Array.copyToStart(ch, a - move, move, ms);
            ms[move] = single;
            out[0] = new InnerNode<N, E>(ls);
            out[1] = new InnerNode<N, E>(ms);
            out[2] = right;
            return out;
        }
        if (right != null && right.arity() > 2) {
            Node<N, E>[] ch = ((InnerNode)right).children;
            int a = ch.length;
            int move = (a - 1) / 2;
            Node[] ms = new Node[move + 1];
            Node[] rs = new Node[a - move];
            ms[0] = single;
            Array.copyFromStart(ch, move, ms, 1);
            Array.copyToStart(ch, move, rs.length, rs);
            out[0] = left;
            out[1] = new InnerNode<N, E>(ms);
            out[2] = new InnerNode<N, E>(rs);
            return out;
        }
        if (left != null) {
            Node<N, E>[] ch = ((InnerNode)left).children;
            int a = ch.length;
            Node[] ls = new Node[a + 1];
            Array.copy(ch, a, ls);
            ls[a] = single;
            out[0] = new InnerNode<N, E>(ls);
            out[2] = right;
            return out;
        }
        if (right != null) {
            Node<N, E>[] ch = ((InnerNode)right).children;
            int a = ch.length;
            Node[] rs = new Node[a + 1];
            rs[0] = single;
            Array.copyFromStart(ch, a, rs, 1);
            out[0] = null;
            out[2] = new InnerNode<N, E>(rs);
            return out;
        }
        out[0] = null;
        out[1] = new PartialInnerNode(single);
        out[2] = null;
        return out;
    }

    @Override
    public NodeLike<Node<N, E>, E> slice(long start, long len) {
        Node<N, E> fst;
        int p = 0;
        while (start >= this.bounds[p]) {
            ++p;
        }
        long off = p == 0 ? start : start - this.bounds[p - 1];
        long end = start + len - 1L;
        int l = p;
        while (end >= this.bounds[p]) {
            ++p;
        }
        int r = p;
        Node<N, E> first = this.children[l];
        long inFst = Math.min(this.bounds[l] - start, len);
        NodeLike<N, E> nodeLike = fst = inFst == first.size() ? first : first.slice(off, inFst);
        if (l == r) {
            return new PartialInnerNode<N, E>(fst);
        }
        NodeLike[] buffer = new NodeLike[r - l + 1];
        buffer[0] = fst;
        int inBuffer = 1;
        for (int i = l + 1; i < r; ++i) {
            inBuffer = this.children[i].append(buffer, inBuffer);
        }
        long inLst = start + len - this.bounds[r - 1];
        Node<N, E> last = this.children[r];
        NodeLike<N, E> lst = inLst == last.size() ? last : last.slice(0L, inLst);
        inBuffer = lst.append(buffer, inBuffer);
        if (inBuffer == 1) {
            return new PartialInnerNode(buffer[0]);
        }
        Node[] subs = new Node[inBuffer];
        Array.copy(buffer, inBuffer, subs);
        return new InnerNode<N, E>(subs);
    }

    @Override
    public long checkInvariants() {
        int a = this.children.length;
        if (a < 2 || a > 4) {
            throw new AssertionError((Object)("Wrong arity: " + a));
        }
        long b = 0L;
        for (int i = 0; i < a; ++i) {
            Node<N, E> ch = this.children[i];
            if ((b += ch.checkInvariants()) != this.bounds[i]) {
                throw new AssertionError((Object)("Wrong boundary: " + b));
            }
        }
        return b;
    }

    @Override
    public int append(NodeLike<Node<N, E>, E>[] nodes, int pos) {
        Node b;
        Node a;
        if (pos == 0 || nodes[pos - 1] instanceof InnerNode) {
            nodes[pos] = this;
            return pos + 1;
        }
        NodeLike sub = ((PartialInnerNode)nodes[pos - 1]).sub;
        int n = this.children.length;
        if (sub instanceof Node) {
            a = (Node)sub;
            b = this.children[0];
        } else {
            NodeLike<Node<N, E>, E>[] buffer = nodes;
            buffer[pos - 1] = sub;
            if (this.children[0].append(buffer, pos) == pos) {
                nodes[pos - 1] = this.replaceFirst((Node)buffer[pos - 1]);
                return pos;
            }
            a = (Node)buffer[pos - 1];
            b = (Node)buffer[pos];
        }
        if (n < 4) {
            Node[] ch = new Node[n + 1];
            Array.copy(this.children, 1, n - 1, ch, 2);
            ch[0] = a;
            ch[1] = b;
            nodes[pos - 1] = new InnerNode<N, E>(ch);
            nodes[pos] = null;
            return pos;
        }
        int rl = (n + 1) / 2;
        int ll = n + 1 - rl;
        Node[] ls = new Node[ll];
        Node[] rs = new Node[rl];
        Array.copy(this.children, 1, ll - 2, ls, 2);
        ls[0] = a;
        ls[1] = b;
        Array.copyToStart(this.children, ll - 1, rl, rs);
        nodes[pos - 1] = new InnerNode<N, E>(ls);
        nodes[pos] = new InnerNode<N, E>(rs);
        return pos + 1;
    }

    public void toString(StringBuilder sb, int indent) {
        sb.append("  ".repeat(indent)).append("Node(").append(this.size()).append(")[\n");
        for (Node<N, E> sub : this.children) {
            FingerTree.toString(sub, sb, indent + 1);
            sb.append('\n');
        }
        sb.append("  ".repeat(indent)).append(']');
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 0);
        return sb.toString();
    }

    InnerNode<N, E> replaceFirst(Node<N, E> newFirst) {
        Node[] copy = (Node[])this.children.clone();
        copy[0] = newFirst;
        return new InnerNode<N, E>(copy);
    }

    InnerNode<N, E> replaceLast(Node<N, E> newLast) {
        Node[] copy = (Node[])this.children.clone();
        copy[copy.length - 1] = newLast;
        return new InnerNode<N, E>(copy);
    }
}

