/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.sql.SqlFn;
import org.basex.query.value.item.Uri;
import org.basex.util.InputInfo;
import org.basex.util.Strings;

public final class SqlConnect
extends SqlFn {
    private static final String AUTOCOMMIT = "autocommit";
    private static final String USER = "user";
    private static final String PASS = "password";

    @Override
    public Uri item(QueryContext qc, InputInfo ii) throws QueryException {
        Connection conn;
        String url = this.toString(this.arg(0), qc);
        String username = this.toStringOrNull(this.arg(1), qc);
        String password = this.toStringOrNull(this.arg(2), qc);
        HashMap<String, String> options = this.toOptions(this.arg(3), qc);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)options);
        if (username != null) {
            props.setProperty(USER, username);
        }
        if (password != null) {
            props.setProperty(PASS, password);
        }
        Object auto = props.remove(AUTOCOMMIT);
        try {
            conn = DriverManager.getConnection(url, props);
            if (auto != null) {
                conn.setAutoCommit(Strings.toBoolean(auto.toString()));
            }
        }
        catch (SQLException ex) {
            throw QueryError.SQL_ERROR_X.get(this.info, ex);
        }
        return SqlConnect.jdbc(qc).add(conn, url);
    }
}

