/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.job;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.TimeZone;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.JobContext;
import org.basex.core.jobs.JobPool;
import org.basex.core.jobs.JobsText;
import org.basex.core.jobs.QueryJobResult;
import org.basex.core.jobs.QueryJobTask;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class JobListDetails
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Context ctx = qc.context;
        TokenList ids = this.defined(0) ? (TokenList)new TokenList(1L).add(this.toToken(this.arg(0), qc)) : qc.context.jobs.ids();
        int max = ctx.soptions.get(StaticOptions.LOGMSGMAXLEN);
        JobPool jobs = ctx.jobs;
        ValueBuilder vb = new ValueBuilder(qc);
        for (byte[] id : ids) {
            String key = Token.string(id);
            Job job = jobs.active.get(key);
            QueryJobResult jr = jobs.results.get(key);
            if (job == null && jr != null) {
                job = jr.job;
            }
            QueryJobTask jt = jobs.tasks.get(key);
            if (job == null && jt != null) {
                job = jt.job;
            }
            if (job == null) continue;
            JobContext jc = job.jc();
            long ms = jc.performance != null ? jc.performance.ns(false) / 1000000L : (jr != null ? jr.time / 1000000L : -1L);
            FBuilder elem = FElem.build(JobsText.Q_JOB);
            elem.add(JobsText.Q_ID, key);
            elem.add(JobsText.Q_TYPE, jc.type());
            elem.add(JobsText.Q_STATE, job.state.name().toLowerCase(Locale.ENGLISH));
            elem.add(JobsText.Q_USER, jc.context.clientName());
            if (ms >= 0L) {
                elem.add(JobsText.Q_DURATION, DTDur.get(ms).string(this.info));
            }
            if (jt != null) {
                elem.add(JobsText.Q_START, this.dateTime(jt.start));
                if (jt.end != Long.MAX_VALUE) {
                    elem.add(JobsText.Q_END, this.dateTime(jt.end));
                }
                if (jt.interval != 0L) {
                    elem.add(JobsText.Q_INTERVAL, DTDur.get(jt.interval).string(this.info));
                }
            }
            elem.add(JobsText.Q_READS, jc.locks.reads);
            elem.add(JobsText.Q_WRITES, jc.locks.writes);
            elem.add(JobsText.Q_TIME, this.dateTime(jc.time));
            elem.add(Token.chop(Token.normalize(Token.token(jc)), max));
            vb.add(elem.finish());
        }
        return vb.value(this);
    }

    private byte[] dateTime(long ms) throws QueryException {
        Dtm dtm = Dtm.get(ms);
        DTDur tz = new DTDur(BigDecimal.valueOf(TimeZone.getDefault().getOffset(ms) / 1000));
        dtm.timeZone(tz, false, this.info);
        return dtm.string(this.info);
    }
}

