/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;

public final class FnSubstring
extends StandardFunc {
    @Override
    public AStr item(QueryContext qc, InputInfo ii) throws QueryException {
        AStr value = this.toZeroStr(this.arg(0), qc);
        int length = value.length(this.info);
        int start = this.start(qc);
        int end = this.length(length, qc);
        if (length == 0 || start == Integer.MIN_VALUE) {
            return Str.EMPTY;
        }
        if (start < 0) {
            end += start;
            start = 0;
        }
        end = Math.min(length, this.defined(2) ? start + end : Integer.MAX_VALUE);
        return start < end ? value.substring(this.info, start, end) : Str.EMPTY;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        int length;
        Expr value = this.arg(0);
        if (value == Empty.VALUE || value == Str.EMPTY) {
            return Str.EMPTY;
        }
        int start = this.arg(1) instanceof Value ? this.start(cc.qc) : Integer.MAX_VALUE;
        int n = length = !this.defined(2) || this.arg(2) instanceof Value ? this.length(Integer.MAX_VALUE, cc.qc) : Integer.MIN_VALUE;
        if (start == Integer.MIN_VALUE || length == 0) {
            return Str.EMPTY;
        }
        return start <= 0 && length == Integer.MAX_VALUE && value.seqType().type.isStringOrUntyped() ? cc.function(Function.STRING, this.info, value) : this;
    }

    private int start(QueryContext qc) throws QueryException {
        Item start = this.toAtomItem(this.arg(1), qc);
        if (start instanceof Int) {
            return FnSubstring.limit(start.itr(this.info) - 1L);
        }
        double dbl = start.dbl(this.info);
        return Double.isNaN(dbl) ? Integer.MIN_VALUE : FnSubstring.subPos(dbl);
    }

    private int length(int def, QueryContext qc) throws QueryException {
        Item length = this.arg(2).atomItem(qc, this.info);
        return length.isEmpty() ? def : (length instanceof Int ? (int)length.itr(this.info) : FnSubstring.subPos(length.dbl(this.info) + 1.0));
    }

    private static int subPos(double d) {
        int i = (int)d;
        return FnSubstring.limit(d == (double)i ? (long)(i - 1) : (long)StrictMath.floor(d - 0.5));
    }

    private static int limit(long l) {
        return (int)Math.min(Math.max(-2147483647L, l), 0x7FFFFFFEL);
    }
}

