/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.SeqType;

public final class FnInsertBefore
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        return new Iter(){
            final Iter input;
            final Iter insert;
            final long osize;
            final long isize;
            final long size;
            final long ps;
            final long pos;
            long p;
            boolean last;
            {
                this.input = FnInsertBefore.this.arg(0).iter(qc);
                this.insert = FnInsertBefore.this.arg(2).iter(qc);
                this.osize = this.input.size();
                this.isize = this.insert.size();
                this.size = this.osize != -1L && this.isize != -1L ? this.osize + this.isize : -1L;
                this.ps = FnInsertBefore.this.pos(qc);
                this.p = this.pos = this.osize != -1L ? Math.min(this.ps, this.osize) : this.ps;
            }

            @Override
            public Item next() throws QueryException {
                while (!this.last) {
                    boolean sub = this.p == -1L || --this.p == -1L;
                    Item item = qc.next(sub ? this.insert : this.input);
                    if (item != null) {
                        return item;
                    }
                    if (sub) {
                        --this.p;
                        continue;
                    }
                    this.last = true;
                }
                return this.p >= 0L ? this.insert.next() : null;
            }

            @Override
            public Item get(long i) throws QueryException {
                long off = i - this.pos;
                return off < 0L ? this.input.get(i) : (off < this.isize ? this.insert.get(off) : this.input.get(i - this.isize));
            }

            @Override
            public long size() {
                return this.size;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value input = this.arg(0).value(qc);
        Value insert = this.arg(2).value(qc);
        long osize = input.size();
        long pos = Math.min(this.pos(qc), osize);
        return pos == 0L ? ValueBuilder.concat(insert, input, qc) : (pos == osize ? ValueBuilder.concat(input, insert, qc) : ((Seq)input).insertBefore(pos, insert, qc));
    }

    private long pos(QueryContext qc) throws QueryException {
        return Math.max(0L, this.toLong(this.arg(1), qc) - 1L);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        Expr pos = this.arg(1);
        Expr insert = this.arg(2);
        if (input == Empty.VALUE) {
            return insert;
        }
        if (insert == Empty.VALUE) {
            return input;
        }
        SeqType st = input.seqType();
        SeqType stInsert = insert.seqType();
        long size = input.size();
        long sizeInsert = insert.size();
        if (pos instanceof Value) {
            long ps = this.pos(cc.qc);
            if (ps == 0L) {
                return List.get(cc, this.info, insert, input);
            }
            if (size != -1L && ps >= size) {
                return List.get(cc, this.info, input, insert);
            }
        }
        long sz = size != -1L && sizeInsert != -1L ? size + sizeInsert : -1L;
        this.exprType.assign(st.union(stInsert), st.occ.add(stInsert.occ), sz).data(input, insert);
        return this;
    }
}

