/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.Item;
import org.basex.util.Prop;

public class FileCreateTempFile
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws QueryException, IOException {
        return this.createTemp(false, qc);
    }

    final synchronized Item createTemp(boolean dir, QueryContext qc) throws QueryException, IOException {
        Path file;
        Path root;
        String suffix;
        String prefix = this.toString(this.arg(0), qc);
        String string = suffix = this.defined(1) ? this.toString(this.arg(1), qc) : "";
        if (this.defined(2)) {
            root = this.toPath(this.arg(2), qc);
            if (Files.isRegularFile(root, new LinkOption[0])) {
                throw QueryError.FILE_NO_DIR_X.get(this.info, root);
            }
        } else {
            root = Paths.get(Prop.TEMPDIR, new String[0]);
        }
        Random rnd = new Random();
        while (Files.exists(file = root.resolve(prefix + rnd.nextLong() + suffix), new LinkOption[0])) {
        }
        if (dir) {
            Files.createDirectory(file, new FileAttribute[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
        }
        return FileCreateTempFile.get(file, dir);
    }
}

