/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.basex.io.in.BufferInput;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.value.item.Bin;
import org.basex.util.InputInfo;
import org.basex.util.Util;

final class ZIPOut
extends ArchiveOut {
    private final ZipOutputStream zos;
    private boolean stored;

    ZIPOut(OutputStream os) {
        this.zos = new ZipOutputStream(os);
    }

    @Override
    public void level(int level) {
        this.stored = level == 0;
        this.zos.setMethod(this.stored ? 0 : 8);
        this.zos.setLevel(level);
    }

    @Override
    public void write(ArchiveIn in) throws IOException {
        ZipEntry zi = in.entry();
        ZipEntry zo = new ZipEntry(zi.getName());
        zo.setTime(zi.getTime());
        zo.setComment(zi.getComment());
        if (zi.getMethod() == 0) {
            this.stored = true;
            ArrayOutput out = new ArrayOutput();
            this.write(in, out);
            this.write(zo, out.finish());
        } else {
            this.level(-1);
            this.zos.putNextEntry(zo);
            this.write(in, this.zos);
            this.zos.closeEntry();
        }
    }

    @Override
    public void write(ZipEntry entry, byte[] value) throws IOException {
        if (this.stored) {
            CRC32 crc = new CRC32();
            crc.update(value);
            entry.setCrc(crc.getValue());
            entry.setSize(value.length);
        }
        this.zos.putNextEntry(entry);
        this.zos.write(value);
        this.zos.closeEntry();
    }

    @Override
    public void write(ZipEntry entry, Bin bin, InputInfo info) throws IOException, QueryException {
        if (this.stored) {
            try (BufferInput bi = bin.input(info);){
                CRC32 crc = new CRC32();
                long size = 0L;
                try (CheckedInputStream cis = new CheckedInputStream(bi, crc);){
                    while (cis.read() != -1) {
                        ++size;
                    }
                }
                entry.setCrc(crc.getValue());
                entry.setSize(size);
            }
        }
        this.zos.putNextEntry(entry);
        this.write(bin, this.zos, info);
        this.zos.closeEntry();
    }

    @Override
    public void close() {
        try {
            this.zos.close();
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }
}

