/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.json;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.json.JsonOptions;
import org.basex.io.out.ArrayOutput;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.json.JsonSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryIOException;
import org.basex.query.util.ft.FTPos;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.BoolList;
import org.basex.util.list.TokenList;

public final class JsonNodeSerializer
extends JsonSerializer {
    private final TokenSet[] typeCache = new TokenSet[JsonConstants.TYPES.length];
    private final BoolList comma = new BoolList();
    private final TokenList types = new TokenList();
    private final boolean lax;
    private final boolean atts;
    private final ArrayOutput cache = new ArrayOutput();
    private byte[] key;
    private boolean custom;
    private Serializer nodeSerializer;

    public JsonNodeSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
        int tl = this.typeCache.length;
        for (int t = 0; t < tl; ++t) {
            this.typeCache[t] = new TokenMap();
        }
        this.atts = this.jopts.get(JsonOptions.FORMAT) == JsonOptions.JsonFormat.ATTRIBUTES;
        this.lax = this.jopts.get(JsonOptions.LAX) != false || this.atts;
    }

    @Override
    protected void node(ANode node) throws IOException {
        Type type = node.type;
        if (type == NodeType.DOCUMENT_NODE || this.custom) {
            super.node(node);
        } else if (this.level == 0 && type == NodeType.ELEMENT && Token.eq(JsonConstants.JSON, node.name())) {
            boolean c = this.custom;
            this.custom = true;
            super.node(node);
            this.custom = c;
        } else {
            try (Serializer ser = this.nodeSerializer();){
                ser.serialize(node);
                ser.reset();
            }
            this.string(this.cache.next());
        }
    }

    @Override
    protected void startOpen(QNm name) {
        this.types.set(this.level, null);
        this.comma.set(this.level + 1, false);
        this.key = this.atts ? null : name.string();
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
        if (this.level == 0) {
            int tl = this.typeCache.length;
            for (int t = 0; t < tl; ++t) {
                if (!Token.eq(name, JsonConstants.ATTRS[t])) continue;
                for (byte[] b : Token.split(value, 32)) {
                    this.typeCache[t].add(b);
                }
                return;
            }
        }
        if (Token.eq(name, JsonConstants.TYPE)) {
            if (!Token.eq(value, JsonConstants.TYPES)) {
                throw JsonNodeSerializer.error("<%> has invalid type \"%\"", this.elem, value);
            }
            this.types.set(this.level, value);
        } else if (this.atts && Token.eq(name, JsonConstants.NAME)) {
            this.key = value;
            if (!Token.eq(this.elem.string(), JsonConstants.PAIR)) {
                throw JsonNodeSerializer.error("<%> found, <pair> expected", this.elem);
            }
        } else if (!Token.eq(name, Token.XMLNS) && !Token.startsWith(name, Token.XMLNS_COLON)) {
            throw JsonNodeSerializer.error("<%> has invalid attribute \"%\"", this.elem, name);
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        byte[] type;
        if (this.comma.get(this.level)) {
            this.out.print(44);
        } else {
            this.comma.set(this.level, true);
        }
        if (this.level > 0) {
            this.indent();
            byte[] ptype = (byte[])this.types.get(this.level - 1);
            if (Token.eq(ptype, JsonConstants.OBJECT)) {
                byte[] name;
                if (this.atts && !Token.eq(this.elem.string(), JsonConstants.PAIR)) {
                    throw JsonNodeSerializer.error("<%> found, <%> expected", this.elem, JsonConstants.PAIR);
                }
                if (this.key == null) {
                    throw JsonNodeSerializer.error("<%> has no name attribute", this.elem);
                }
                this.out.print(34);
                byte[] byArray = name = this.atts ? this.key : XMLToken.decode(this.key, this.lax);
                if (name == null) {
                    throw JsonNodeSerializer.error("Name of element <%> is invalid", new Object[]{this.key});
                }
                this.out.print(Token.normalize(name, this.form));
                this.out.print("\":");
            } else if (Token.eq(ptype, JsonConstants.ARRAY)) {
                if (this.atts) {
                    if (!Token.eq(this.elem.string(), JsonConstants.ITEM)) {
                        throw JsonNodeSerializer.error("<%> found, <%> expected", this.elem, JsonConstants.ITEM);
                    }
                    if (this.key != null) {
                        throw JsonNodeSerializer.error("<%> must have no name attribute", this.elem);
                    }
                } else if (!Token.eq(this.elem.string(), JsonConstants.VALUE)) {
                    throw JsonNodeSerializer.error("<%> found, <%> expected", this.elem, JsonConstants.VALUE);
                }
            } else {
                throw JsonNodeSerializer.error("<%> is typed as \"%\" and cannot be nested", this.opened.get(this.level - 1), ptype);
            }
        }
        if ((type = (byte[])this.types.get(this.level)) == null) {
            if (this.key != null) {
                int tl = this.typeCache.length;
                for (int t = 0; t < tl && type == null; ++t) {
                    if (!this.typeCache[t].contains(this.key)) continue;
                    type = JsonConstants.TYPES[t];
                }
            }
            if (type == null) {
                type = JsonConstants.STRING;
            }
            this.types.set(this.level, type);
        }
        if (Token.eq(type, JsonConstants.OBJECT)) {
            this.out.print(123);
        } else if (Token.eq(type, JsonConstants.ARRAY)) {
            this.out.print(91);
        }
    }

    @Override
    protected void text(byte[] value, FTPos ftp) throws IOException {
        byte[] type = (byte[])this.types.get(this.level - 1);
        if (Token.eq(type, JsonConstants.STRING)) {
            this.out.print(34);
            for (byte ch : Token.normalize(value, this.form)) {
                this.printChar(ch);
            }
            this.out.print(34);
        } else if (Token.eq(type, JsonConstants.BOOLEAN)) {
            if (!Token.eq(value, Token.TRUE, Token.FALSE)) {
                throw JsonNodeSerializer.error("Value of <%> is no boolean: \"%\"", this.opened.get(this.level - 1), value);
            }
            this.out.print(value);
        } else if (Token.eq(type, JsonConstants.NUMBER)) {
            if (Double.isNaN(Token.toDouble(value))) {
                throw JsonNodeSerializer.error("Value of <%> is no number: \"%\"", this.opened.get(this.level - 1), value);
            }
            this.out.print(value);
        } else if (Token.trim(value).length != 0) {
            throw JsonNodeSerializer.error("<%> is typed as \"%\" and cannot have a value", this.opened.get(this.level - 1), type);
        }
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        byte[] type = (byte[])this.types.get(this.level);
        if (Token.eq(type, JsonConstants.STRING)) {
            this.out.print("\"\"");
        } else if (Token.eq(type, JsonConstants.NULL)) {
            this.out.print(JsonConstants.NULL);
        } else if (!Token.eq(type, JsonConstants.OBJECT, JsonConstants.ARRAY)) {
            throw JsonNodeSerializer.error("Value expected for type \"%\"", new Object[]{type});
        }
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        byte[] type = (byte[])this.types.get(this.level);
        if (Token.eq(type, JsonConstants.ARRAY)) {
            this.indent();
            this.out.print(93);
        } else if (Token.eq(type, JsonConstants.OBJECT)) {
            this.indent();
            this.out.print(125);
        }
    }

    private static QueryIOException error(String msg, Object ... ext) {
        return QueryError.JSON_SERIALIZE_X.getIO(new Object[]{Util.inf(msg, ext)});
    }

    private Serializer nodeSerializer() throws IOException {
        if (this.nodeSerializer == null) {
            SerializerOptions so = new SerializerOptions();
            so.set(SerializerOptions.METHOD, this.sopts.get(SerializerOptions.JSON_NODE_OUTPUT_METHOD));
            this.nodeSerializer = Serializer.get(this.cache, so);
        }
        return this.nodeSerializer;
    }
}

