/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.IndexCache;
import org.basex.index.IndexEntry;
import org.basex.index.IndexType;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.FTIndexIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexSearch;
import org.basex.index.stats.IndexStats;
import org.basex.index.value.ValueCache;
import org.basex.index.value.ValueIndex;
import org.basex.io.random.DataAccess;
import org.basex.query.expr.ft.FTWildcard;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.util.index.IndexCosts;
import org.basex.util.Array;
import org.basex.util.Performance;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.IntList;
import org.basex.util.similarity.Levenshtein;

public final class FTIndex
extends ValueIndex {
    private static final int ENTRY = 9;
    private final IntObjMap<byte[]> ctext = new IntObjMap();
    private final Levenshtein ls = new Levenshtein();
    private final DataAccess dataX;
    private final DataAccess dataY;
    private final DataAccess dataZ;
    private final IndexCache cache = new IndexCache();
    private final int[] positions;

    public FTIndex(Data data) throws IOException {
        super(data, IndexType.FULLTEXT);
        this.dataX = new DataAccess(data.meta.dbFile("ftxx"));
        this.dataY = new DataAccess(data.meta.dbFile("ftxy"));
        this.dataZ = new DataAccess(data.meta.dbFile("ftxz"));
        this.positions = new int[data.meta.maxlen + 3];
        int pl = this.positions.length;
        for (int p = 0; p < pl; ++p) {
            this.positions[p] = -1;
        }
        int is = this.dataX.readNum();
        while (--is >= 0) {
            int p = this.dataX.readNum();
            this.positions[p] = this.dataX.read4();
        }
        this.positions[pl - 1] = (int)this.dataY.length();
    }

    @Override
    public synchronized IndexCosts costs(IndexSearch search) {
        byte[] token = search.token();
        if (token.length > this.data.meta.maxlen) {
            return null;
        }
        FTOpt opt = ((FTLexer)search).ftOpt();
        return IndexCosts.get(opt.is(FTFlag.FZ) || opt.is(FTFlag.WC) ? Math.max(1, this.data.meta.size >> 4) : this.entry((byte[])token).size);
    }

    @Override
    public synchronized IndexIterator iter(IndexSearch search) {
        FTLexer lexer = (FTLexer)search;
        FTOpt opt = lexer.ftOpt();
        byte[] token = lexer.token();
        if (opt.is(FTFlag.WC)) {
            FTWildcard wc = new FTWildcard(token);
            if (!wc.valid()) {
                return FTIndexIterator.FTEMPTY;
            }
            if (!wc.simple()) {
                return this.wildcards(wc, opt.is(FTFlag.DC), token);
            }
        }
        if (opt.is(FTFlag.FZ)) {
            return this.fuzzy(token, lexer.errors(token));
        }
        IndexEntry entry = this.entry(token);
        if (entry.size > 0) {
            return FTIndex.iter(entry.offset, entry.size, this.dataZ, token);
        }
        return FTIndexIterator.FTEMPTY;
    }

    private IndexEntry entry(byte[] value) {
        IndexEntry entry = this.cache.get(value);
        if (entry != null) {
            return entry;
        }
        long pt = this.token(value);
        return pt == -1L ? new IndexEntry(value, 0, 0L) : this.cache.add(value, this.size(pt, value.length), this.pointer(pt, value.length));
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        final byte[] token = entries.token();
        return new EntryIterator(){
            int p;
            int start;
            int end;
            int nr;
            boolean inner;
            {
                this.p = token.length - 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] next() {
                FTIndex fTIndex = FTIndex.this;
                synchronized (fTIndex) {
                    byte[] entry;
                    if (this.inner && this.start < this.end && Token.startsWith(entry = FTIndex.this.dataY.readBytes(this.start, this.p), token)) {
                        long poi = FTIndex.this.dataY.read5();
                        this.nr = FTIndex.this.dataY.read4();
                        if (token.length != 0) {
                            FTIndex.this.cache.add(entry, this.nr, poi);
                        }
                        this.start += this.p + 9;
                        return entry;
                    }
                    int pl = FTIndex.this.positions.length;
                    while (++this.p < pl - 1) {
                        this.start = FTIndex.this.positions[this.p];
                        if (this.start == -1) continue;
                        int c = this.p + 1;
                        do {
                            this.end = FTIndex.this.positions[c++];
                        } while (this.end == -1);
                        this.nr = 0;
                        this.inner = true;
                        this.start = FTIndex.this.find(token, this.start, this.end, this.p);
                        byte[] n = this.next();
                        if (n == null) continue;
                        return n;
                    }
                    return null;
                }
            }

            @Override
            public int count() {
                return this.nr;
            }
        };
    }

    private int find(byte[] token, int start, int end, int ti) {
        int tl = ti + 9;
        int s = 0;
        int e = (end - start) / tl;
        while (s <= e) {
            int m = s + e >>> 1;
            int pos = start + m * tl;
            int d = Token.diff(this.cache(pos, ti), token);
            if (d == 0) {
                return start + m * tl;
            }
            if (d < 0) {
                s = m + 1;
                continue;
            }
            e = m - 1;
        }
        return start + s * tl;
    }

    private byte[] cache(int pos, int ti) {
        if (ti >= 128) {
            return this.dataY.readBytes(pos, ti);
        }
        int key = (ti << 24) + pos;
        return this.ctext.computeIfAbsent(key, () -> this.dataY.readBytes(pos, ti));
    }

    @Override
    public synchronized byte[] info(MainOptions options) {
        TokenBuilder tb = new TokenBuilder();
        long l = this.dataX.length() + this.dataY.length() + this.dataZ.length();
        tb.add("- Names: ").add(this.data.meta.ftinclude).add(Text.NL);
        tb.add("- Size: ").add(Performance.format(l)).add(Text.NL);
        IndexStats stats = new IndexStats(options.get(MainOptions.MAXSTAT));
        this.addOccs(stats);
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public boolean drop() {
        return this.data.meta.drop("ftx.");
    }

    @Override
    public synchronized void close() {
        this.dataX.close();
        this.dataY.close();
        this.dataZ.close();
    }

    @Override
    public int size() {
        int pl = this.positions.length;
        int size = 0;
        int t = pl - 1;
        while (true) {
            int e = t;
            while (this.positions[--t] == -1) {
                if (t != 0) continue;
                return size;
            }
            size += (this.positions[e] - this.positions[t]) / (t + 9);
        }
    }

    private int token(byte[] token) {
        int e;
        int tl = token.length;
        int s = this.positions[tl];
        if (s == -1) {
            return -1;
        }
        int i = 1;
        while ((e = this.positions[tl + i++]) == -1) {
        }
        int x = e;
        int o = tl + 9;
        while (s < e) {
            int m = s + (e - s >> 1) / o * o;
            int d = Token.diff(this.dataY.readBytes(m, tl), token);
            if (d == 0) {
                return m;
            }
            if (d < 0) {
                s = m + o;
                continue;
            }
            e = m - o;
        }
        return e != x && s == e && Token.eq(this.dataY.readBytes(s, tl), token) ? s : -1;
    }

    private void addOccs(IndexStats stats) {
        int j;
        int i;
        int pl = this.positions.length;
        for (i = 0; i < pl && this.positions[i] == -1; ++i) {
        }
        int p = this.positions[i];
        for (j = i + 1; j < pl && this.positions[j] == -1; ++j) {
        }
        int max = this.positions[pl - 1];
        while (p < max) {
            int oc = this.size(p, i);
            if (stats.adding(oc)) {
                stats.add(this.dataY.readBytes(p, i), oc);
            }
            if ((p += i + 9) != this.positions[j]) continue;
            i = j;
            while (j + 1 < pl && this.positions[++j] == -1) {
            }
        }
    }

    private long pointer(long pt, int lt) {
        return this.dataY.read5(pt + (long)lt);
    }

    private int size(long pt, int lt) {
        return this.dataY.read4(pt + (long)lt + 5L);
    }

    private IndexIterator fuzzy(byte[] token, int k) {
        int tokl = token.length;
        int pl = this.positions.length;
        int e = Math.min(pl - 1, tokl + k);
        int s = Math.max(1, tokl - k) - 1;
        ArrayList<FTIndexIterator> iters = new ArrayList<FTIndexIterator>();
        while (++s <= e) {
            int p = this.positions[s];
            if (p == -1) continue;
            int t = s + 1;
            int r = -1;
            while (t < pl && r == -1) {
                r = this.positions[t++];
            }
            while (p < r) {
                if (this.ls.similar(this.dataY.readBytes(p, s), token, k)) {
                    iters.add(FTIndex.iter(this.pointer(p, s), this.size(p, s), this.dataZ, token));
                }
                p += s + 9;
            }
        }
        return iters.isEmpty() ? FTIndexIterator.FTEMPTY : FTIndexIterator.union((FTIndexIterator[])iters.toArray(FTIndexIterator[]::new));
    }

    private IndexIterator wildcards(FTWildcard wc, boolean full, byte[] token) {
        IntList pr = new IntList();
        IntList ps = new IntList();
        byte[] prefix = wc.prefix();
        int pl = this.positions.length;
        int l = Math.min(pl - 1, wc.max(full));
        for (int p = prefix.length; p <= l; ++p) {
            byte[] t;
            int start = this.positions[p];
            if (start == -1) continue;
            int c = p + 1;
            int end = -1;
            while (c < pl && end == -1) {
                end = this.positions[c++];
            }
            for (start = this.find(prefix, start, end, p); start < end && Token.startsWith(t = this.dataY.readBytes(start, p), prefix); start += p + 9) {
                if (!wc.match(t)) continue;
                this.dataZ.cursor(this.pointer(start, p));
                int s = this.size(start, p);
                for (int d = 0; d < s; ++d) {
                    pr.add(this.dataZ.readNum());
                    ps.add(this.dataZ.readNum());
                }
            }
        }
        return FTIndex.iter(new FTCache(pr, ps), token);
    }

    private static FTIndexIterator iter(long off, int size, DataAccess da, byte[] token) {
        da.cursor(off);
        IntList pr = new IntList(size);
        IntList ps = new IntList(size);
        for (int c = 0; c < size; ++c) {
            pr.add(da.readNum());
            ps.add(da.readNum());
        }
        return FTIndex.iter(new FTCache(pr, ps), token);
    }

    private static FTIndexIterator iter(final FTCache ftc, final byte[] token) {
        final int size = ftc.pre.size();
        return new FTIndexIterator(){
            final FTMatches all = new FTMatches();
            int pos;
            int pre;
            int c;

            @Override
            public boolean more() {
                if (this.c == size) {
                    return false;
                }
                this.all.reset(this.pos);
                int o = ftc.order[this.c];
                this.pre = ftc.pre.get(o);
                this.all.or(ftc.pos.get(o));
                while (++this.c < size && this.pre == ftc.pre.get(o = ftc.order[this.c])) {
                    this.all.or(ftc.pos.get(o));
                }
                return true;
            }

            @Override
            public FTMatches matches() {
                return this.all;
            }

            @Override
            public int pre() {
                return this.pre;
            }

            @Override
            public void pos(int p) {
                this.pos = p;
            }

            @Override
            public int size() {
                return size;
            }

            public String toString() {
                return Strings.concat(token, Character.valueOf('('), size, "x)");
            }
        };
    }

    @Override
    public void add(ValueCache values) {
        throw Util.notExpected();
    }

    @Override
    public void delete(ValueCache values) {
        throw Util.notExpected();
    }

    @Override
    public void flush() {
    }

    private static final class FTCache {
        private final int[] order;
        private final IntList pre;
        private final IntList pos;

        private FTCache(IntList pr, IntList ps) {
            int s = pr.size();
            long[] v = new long[s];
            for (int i = 0; i < s; ++i) {
                v[i] = (long)pr.get(i) << 32 | (long)ps.get(i);
            }
            this.order = Array.createOrder(v, true);
            this.pre = pr;
            this.pos = ps;
        }
    }
}

