/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.XQuery;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogAbout;
import org.basex.gui.dialog.DialogBindings;
import org.basex.gui.dialog.DialogColors;
import org.basex.gui.dialog.DialogEdit;
import org.basex.gui.dialog.DialogExport;
import org.basex.gui.dialog.DialogFonts;
import org.basex.gui.dialog.DialogInsert;
import org.basex.gui.dialog.DialogManage;
import org.basex.gui.dialog.DialogMem;
import org.basex.gui.dialog.DialogNew;
import org.basex.gui.dialog.DialogPackages;
import org.basex.gui.dialog.DialogPrefs;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogProps;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.text.TextEditor;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.editor.EditorArea;
import org.basex.io.IOFile;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.func.Function;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.DBNodes;
import org.basex.query.value.type.NodeType;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.options.Options;

public enum GUIMenuCmd implements GUICommand
{
    C_CREATE(Text.NEW + "...", "% N", false, false){

        @Override
        public void execute(GUI gui) {
            DialogNew dialog = new DialogNew(gui);
            if (!dialog.ok()) {
                return;
            }
            String in = gui.gopts.get(GUIOptions.INPUTPATH);
            String db = gui.gopts.get(GUIOptions.DBNAME);
            DialogProgress.execute(gui, new CreateDB(db, in.isEmpty() ? null : in));
        }
    }
    ,
    C_OPEN_MANAGE(Text.OPEN_MANAGE + "...", "% M", false, false){

        @Override
        public void execute(GUI gui) {
            if (new DialogManage(gui).nodb() && BaseXDialog.confirm(gui, Text.NEW_DB_QUESTION)) {
                C_CREATE.execute(gui);
            }
        }
    }
    ,
    C_PROPERTIES(Text.PROPERTIES + "...", "% shift M", true, false){

        @Override
        public void execute(GUI gui) {
            new DialogProps(gui);
        }
    }
    ,
    C_EXPORT(Text.EXPORT + "...", null, true, false){

        @Override
        public void execute(GUI gui) {
            DialogExport dialog = new DialogExport(gui);
            if (!dialog.ok()) {
                return;
            }
            IOFile root = new IOFile(dialog.path());
            if (root.exists()) {
                IOFile file = null;
                boolean overwrite = false;
                Data data = gui.context.data();
                IntList docs = data.resources.docs();
                int ds = docs.size();
                for (int d = 0; d < ds; ++d) {
                    file = root.resolve(Token.string(data.text(docs.get(d), true)));
                    if (!file.exists()) continue;
                    if (overwrite) {
                        file = null;
                        break;
                    }
                    overwrite = true;
                }
                if (overwrite) {
                    String msg;
                    String string = msg = file == null ? Text.FILES_REPLACE_X : Text.FILE_EXISTS_X;
                    if (file == null) {
                        file = root;
                    }
                    if (!BaseXDialog.confirm(gui, Util.info(msg, file))) {
                        return;
                    }
                }
            }
            DialogProgress.execute(gui, new Export(root.path()));
        }
    }
    ,
    C_CLOSE(Text.CLOSE, "% Q", true, false){

        @Override
        public void execute(GUI gui) {
            gui.execute(new Close());
        }
    }
    ,
    C_EDIT_NEW(Text.NEW, "% T", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.newFile();
        }
    }
    ,
    C_EDIT_OPEN(Text.OPEN + "...", "% O", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.open();
        }
    }
    ,
    C_EDIT_REOPEN(Text.REOPEN + "...", null, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().reopen(true);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_EDIT_SAVE(Text.SAVE, "% S", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.save();
        }

        @Override
        public boolean enabled(GUI gui) {
            EditorArea ea = gui.editor.getEditor();
            return gui.gopts.get(GUIOptions.SHOWEDITOR) != false && ea != null && (ea.modified() || !ea.opened());
        }
    }
    ,
    C_EDIT_SAVE_AS(Text.SAVE_AS + "...", "% shift S", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.saveAs();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_EDIT_CLOSE(Text.CLOSE, "% W", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.close(null);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_EDIT_CLOSE_ALL(Text.CLOSE_ALL, "% shift W", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.closeAll();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_EXTERNAL_VARIABLES(Text.EXTERNAL_VARIABLES, "% shift E", false, false){

        @Override
        public void execute(GUI gui) {
            new DialogBindings(gui);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_INDENT_RESULT(Text.INDENT_RESULT, "% shift I", false, true){

        @Override
        public void execute(GUI gui) {
            SerializerOptions sopts = gui.context.options.get(MainOptions.SERIALIZER);
            sopts.put(SerializerOptions.INDENT, (Object)(this.selected(gui) ? Options.YesNo.NO : Options.YesNo.YES));
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            SerializerOptions sopts = gui.context.options.get(MainOptions.SERIALIZER);
            return sopts.get(SerializerOptions.INDENT) == Options.YesNo.YES;
        }
    }
    ,
    C_NEXT_ERROR(Text.NEXT_ERROR, "% PERIOD", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.markError(true);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_COMMENT(Text.COMMENT, "% K", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().comment();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_FORMAT(Text.FORMAT, "% shift F", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().format();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_SORT(Text.SORT, "% U", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().sort();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_LOWER_CASE(Text.LOWER_CASE, "% shift L", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().toCase(TextEditor.Case.LOWER);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_UPPER_CASE(Text.UPPER_CASE, "% shift U", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().toCase(TextEditor.Case.UPPER);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_TITLE_CASE(Text.TITLE_CASE, "% shift T", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().toCase(TextEditor.Case.TITLE);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_JUMP_TO_BRACKET(Text.JUMP_TO_BRACKET, "% shift B", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().bracket();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_EXIT(Text.EXIT, null, false, false){

        @Override
        public void execute(GUI gui) {
            gui.quit();
        }
    }
    ,
    C_COPY_PATH(Text.COPY_PATH, "% shift C", true, false){

        @Override
        public void execute(GUI gui) {
            int pre = gui.context.marked.pre(0);
            BaseXLayout.toClipboard(Token.string(ViewData.path(gui.context.data(), pre)));
        }

        @Override
        public boolean enabled(GUI gui) {
            DBNodes marked = gui.context.marked;
            return marked != null && !marked.isEmpty();
        }
    }
    ,
    C_COPY_NODES(Text.COPY, null, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            DBNodes n = ctx.marked;
            ctx.copied = new DBNodes(n.data(), n.pres());
        }

        @Override
        public boolean enabled(GUI gui) {
            return GUIMenuCmd.updatable(gui.context.marked, new int[0]);
        }
    }
    ,
    C_PASTE_NODES(Text.PASTE, null, true, false){

        @Override
        public void execute(GUI gui) {
            StringBuilder sb = new StringBuilder();
            DBNodes n = gui.context.copied;
            long ns = n.size();
            int i = 0;
            while ((long)i < ns) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(GUIMenuCmd.openPre(n, i));
                ++i;
            }
            gui.context.copied = null;
            gui.execute(new XQuery("insert nodes (" + sb + ") into " + GUIMenuCmd.openPre(gui.context.marked, 0)));
        }

        @Override
        public boolean enabled(GUI gui) {
            Context ctx = gui.context;
            return GUIMenuCmd.updatable(ctx.marked, 0) && ctx.copied != null;
        }
    }
    ,
    C_DELETE_NODES(Text.DELETE + "...", null, true, false){

        @Override
        public void execute(GUI gui) {
            if (!BaseXDialog.confirm(gui, Text.DELETE_NODES)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            DBNodes n = gui.context.marked;
            long ns = n.size();
            int i = 0;
            while ((long)i < ns) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(GUIMenuCmd.openPre(n, i));
                ++i;
            }
            gui.context.marked = new DBNodes(n.data(), new int[0]);
            gui.context.copied = null;
            gui.context.focused = -1;
            gui.execute(new XQuery("delete nodes (" + sb + ")"));
        }

        @Override
        public boolean enabled(GUI gui) {
            return GUIMenuCmd.updatable(gui.context.marked, 0);
        }
    }
    ,
    C_NEW_NODES(Text.NEW + "...", null, true, false){

        @Override
        public void execute(GUI gui) {
            DBNodes n = gui.context.marked;
            DialogInsert insert = new DialogInsert(gui);
            if (!insert.ok()) {
                return;
            }
            StringList sl = insert.result;
            NodeType type = ANode.type(insert.kind);
            TokenBuilder item = new TokenBuilder();
            item.add(type.qname().local()).add(" { ").add(GUIMenuCmd.quote((String)sl.get(0))).add(" }");
            if (type.oneOf(NodeType.ATTRIBUTE, NodeType.PROCESSING_INSTRUCTION)) {
                item.add(" { ").add(GUIMenuCmd.quote((String)sl.get(1))).add(" }");
            } else if (type == NodeType.ELEMENT) {
                item.add(" { () }");
            }
            gui.context.copied = null;
            gui.execute(new XQuery("insert node " + item.add(" into ").add(GUIMenuCmd.openPre(n, 0)).toString()));
        }

        @Override
        public boolean enabled(GUI gui) {
            return GUIMenuCmd.updatable(gui.context.marked, 3, 5, 4, 2);
        }
    }
    ,
    C_EDIT_NODES(Text.EDIT + "...", null, true, false){

        @Override
        public void execute(GUI gui) {
            DBNodes n = gui.context.marked;
            DialogEdit edit = new DialogEdit(gui, n.pre(0));
            if (!edit.ok()) {
                return;
            }
            String rename = null;
            String replace = null;
            int k = edit.kind;
            if (k == 1 || k == 5 || k == 3) {
                rename = (String)edit.result.get(0);
                if (k != 1) {
                    replace = (String)edit.result.get(1);
                }
            } else {
                replace = (String)edit.result.get(0);
            }
            if (rename != null) {
                gui.execute(new XQuery("rename node " + GUIMenuCmd.openPre(n, 0) + " as " + GUIMenuCmd.quote(rename)));
            }
            if (replace != null) {
                gui.execute(new XQuery("replace value of node " + GUIMenuCmd.openPre(n, 0) + " with " + GUIMenuCmd.quote(replace)));
            }
        }

        @Override
        public boolean enabled(GUI gui) {
            return GUIMenuCmd.updatable(gui.context.marked, 0);
        }
    }
    ,
    C_FILTER_NODES(Text.FILTER_SELECTED, "alt DOWN", true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            DBNodes marked = ctx.marked;
            if (marked.isEmpty()) {
                int pre = gui.context.focused;
                if (pre == -1) {
                    return;
                }
                marked = new DBNodes(ctx.data(), pre);
            }
            gui.notify.context(marked, false, null);
        }

        @Override
        public boolean enabled(GUI gui) {
            DBNodes marked = gui.context.marked;
            return marked != null && !marked.isEmpty();
        }
    }
    ,
    C_SHOW_EDITOR(Text.EDITOR, "% E", false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWEDITOR);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_JUMP_TO_FILE(Text.JUMP_TO_FILE, "% J", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.showProject();
            gui.editor.jumpToFile();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_FIND_CONTENTS(Text.FIND_CONTENTS, Prop.MAC ? "% shift H" : "% H", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.showProject();
            gui.editor.findFiles();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_SHOW_PROJECT(Text.PROJECT, "% P", false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWPROJECT);
            gui.editor.toggleProject();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWPROJECT);
        }
    }
    ,
    C_SHOW_INFO(Text.INFO, "% I", false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWINFO);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWINFO);
        }
    }
    ,
    C_PACKAGES(Text.PACKAGES + "...", null, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogPackages(gui);
        }
    }
    ,
    C_SHOW_BUTTONS(Text.BUTTONS, null, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWBUTTONS);
            gui.updateControl(gui.buttons, gui.gopts.get(GUIOptions.SHOWBUTTONS), "Center");
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWBUTTONS);
        }
    }
    ,
    C_SHOW_INPUT_BAR(Text.INPUT_BAR, null, false, true){

        @Override
        public void execute(GUI gui) {
            gui.updateControl(gui.nav, gui.gopts.invert(GUIOptions.SHOWINPUT), "South");
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWINPUT);
        }
    }
    ,
    C_SHOW_STATUS_BAR(Text.STATUS_BAR, null, false, true){

        @Override
        public void execute(GUI gui) {
            gui.updateControl(gui.status, gui.gopts.invert(GUIOptions.SHOWSTATUS), "South");
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWSTATUS);
        }
    }
    ,
    C_SHOW_RESULT(Text.RESULT, "% R", false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWTEXT);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWTEXT);
        }
    }
    ,
    C_SHOW_MAP(Text.MAP, "% 1", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWMAP);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWMAP);
        }
    }
    ,
    C_SHOW_TREE(Text.TREE, "% 2", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWTREE);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWTREE);
        }
    }
    ,
    C_SHOW_FOLDER(Text.FOLDER, "% 3", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWFOLDER);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWFOLDER);
        }
    }
    ,
    C_SHOW_PLOT(Text.PLOT, "% 4", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWPLOT);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWPLOT);
        }
    }
    ,
    C_SHOW_TABLE(Text.TABLE, "% 5", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWTABLE);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWTABLE);
        }
    }
    ,
    C_SHOW_EXPLORE(Text.EXPLORER, "% 6", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWEXPLORE);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEXPLORE);
        }
    }
    ,
    C_SHOW_MEM(Text.USED_MEM + "...", null, false, false){

        @Override
        public void execute(GUI gui) {
            DialogMem.show(gui);
        }
    }
    ,
    C_FULLSCREEN(Text.FULLSCREEN, Prop.MAC ? "% shift F" : "F11", false, true){

        @Override
        public void execute(GUI gui) {
            gui.fullscreen();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.fullscreen;
        }
    }
    ,
    C_RT_EXECUTION(Text.RT_EXECUCTION, null, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.EXECRT);
            gui.stop();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.EXECRT);
        }
    }
    ,
    C_RT_FILTERING(Text.RT_FILTERING, null, true, true){

        @Override
        public void execute(GUI gui) {
            boolean rt = gui.gopts.invert(GUIOptions.FILTERRT);
            gui.stop();
            Context ctx = gui.context;
            boolean root = ctx.root();
            Data data = ctx.data();
            if (rt) {
                if (root) {
                    gui.notify.mark(new DBNodes(data, new int[0]), null);
                } else {
                    DBNodes mark = ctx.marked;
                    ctx.marked = new DBNodes(data, new int[0]);
                    gui.notify.context(mark, true, null);
                }
            } else if (!root) {
                gui.notify.context(new DBNodes(data, 0), true, null);
                gui.notify.mark(ctx.current(), null);
            }
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.FILTERRT);
        }
    }
    ,
    C_COLOR(Text.COLORS + "...", null, false, false){

        @Override
        public void execute(GUI gui) {
            DialogColors.show(gui);
        }
    }
    ,
    C_FONTS(Text.FONTS_D, null, false, false){

        @Override
        public void execute(GUI gui) {
            DialogFonts.show(gui);
        }
    }
    ,
    C_PREFERENCES(Text.PREFERENCES + "...", Prop.MAC ? "% COMMA" : "% shift P", false, false){

        @Override
        public void execute(GUI gui) {
            DialogPrefs.show(gui);
        }
    }
    ,
    C_HELP(Text.HELP, "F1", false, false){

        @Override
        public void execute(GUI gui) {
            BaseXDialog.browse(gui, Text.DOCS_URL);
        }
    }
    ,
    C_COMMUNITY(Text.COMMUNITY, null, false, false){

        @Override
        public void execute(GUI gui) {
            BaseXDialog.browse(gui, Text.COMMUNITY_URL);
        }
    }
    ,
    C_CHECK_FOR_UPDATES(Text.CHECK_FOR_UPDATES, null, false, false){

        @Override
        public void execute(GUI gui) {
            gui.checkVersion(true);
        }
    }
    ,
    C_ABOUT(Text.ABOUT + "...", null, false, false){

        @Override
        public void execute(GUI gui) {
            DialogAbout.show(gui);
        }
    }
    ,
    C_GO_BACK(Text.GO_BACK, "alt LEFT", true, false){

        @Override
        public void execute(GUI gui) {
            gui.notify.hist(false);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.notify.query(true) != null;
        }
    }
    ,
    C_GO_FORWARD(Text.GO_FORWARD, "alt RIGHT", true, false){

        @Override
        public void execute(GUI gui) {
            gui.notify.hist(true);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.notify.query(false) != null;
        }
    }
    ,
    C_GO_UP(Text.GO_UP, "alt UP", true, false){

        @Override
        public void execute(GUI gui) {
            DBNodes nodes;
            Context ctx = gui.context;
            if (ctx.root()) {
                return;
            }
            boolean doc = true;
            Data data = ctx.data();
            for (int pre : ctx.current().pres()) {
                doc &= data.kind(pre) == 0;
            }
            if (doc) {
                ctx.invalidate();
                nodes = ctx.current();
            } else {
                IntList pres = new IntList();
                for (int pre : ctx.current().pres()) {
                    int k = data.kind(pre);
                    pres.add(k == 0 ? pre : data.parent(pre, k));
                }
                nodes = new DBNodes(data, pres.ddo().finish());
                ctx.current(nodes);
            }
            gui.notify.context(nodes, false, null);
        }

        @Override
        public boolean enabled(GUI gui) {
            return super.enabled(gui) && !gui.context.root();
        }
    }
    ,
    C_GO_HOME(Text.GO_HOME, "alt HOME", true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            if (ctx.root()) {
                return;
            }
            ctx.invalidate();
            gui.notify.context(ctx.current(), false, null);
        }
    }
    ,
    C_SHOW_HOME(Text.GO_HOME, null, true, false){

        @Override
        public void execute(GUI gui) {
            gui.execute(new XQuery("/"));
        }
    };

    private final String label;
    private final Object key;
    private final boolean data;
    private final boolean toggle;
    private final String shortcut;

    private GUIMenuCmd(String label, String key, boolean data, boolean toggle) {
        this.label = label;
        this.key = key;
        this.data = data;
        this.toggle = toggle;
        this.shortcut = BaseXLayout.addShortcut(label, key);
    }

    @Override
    public boolean enabled(GUI gui) {
        return !this.data || gui.context.data() != null;
    }

    @Override
    public boolean selected(GUI gui) {
        return false;
    }

    @Override
    public final String label() {
        return this.label;
    }

    @Override
    public final boolean toggle() {
        return this.toggle;
    }

    @Override
    public String shortCut() {
        return this.shortcut;
    }

    @Override
    public Object shortcuts() {
        return this.key;
    }

    private static boolean updatable(DBNodes node, int ... kinds) {
        if (node == null || (kinds.length == 0 ? node.size() < 1L : node.size() != 1L)) {
            return false;
        }
        int k = node.data().kind(node.pre(0));
        for (int kind : kinds) {
            if (k != kind) continue;
            return false;
        }
        return true;
    }

    private static String quote(String string) {
        return "\"" + string.replace("\"", "&quot;") + "\"";
    }

    private static String openPre(DBNodes nodes, int index) {
        return Function._DB_GET_PRE.args(nodes.data().meta.name, nodes.pre(index)).trim();
    }
}

